package com.cc.infosur.mytrip;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.cc.infosur.R;

public class ImageFullScreenFragment extends Fragment{
    ImageView imageView;
    boolean isImageFitToScreen;
    byte[] picture;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.image_fullscreen, container, false);

        imageView = (ImageView) v.findViewById(R.id.imageView);
        BitmapFactory.Options bounds = new BitmapFactory.Options();
        bounds.inJustDecodeBounds = true;
        BitmapFactory
                .decodeByteArray(picture, 0,
                        picture.length, bounds);

        BitmapFactory.Options opts = new BitmapFactory.Options();
        Bitmap bmp = BitmapFactory
                .decodeByteArray(picture, 0,
                        picture.length, opts);

        imageView.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT));
        imageView.setScaleType(ImageView.ScaleType.FIT_XY);

        Matrix matrix = new Matrix();
        matrix.setRotate(90, (float) bmp.getWidth() / 2, (float) bmp.getHeight() / 2);
        Bitmap rotatedBitmap = Bitmap.createBitmap(bmp, 0, 0, bounds.outWidth, bounds.outHeight, matrix, true);

        imageView.setImageBitmap(rotatedBitmap);

        return v;
    }

    public byte[] getPicture() {
        return picture;
    }

    public void setPicture(byte[] picture) {
        this.picture = picture;
    }
}
