package com.cc.infosur.map;


import java.util.ArrayList;
import java.util.List;

import com.cc.infosur.R;

import com.cc.infosur.greendao.Detail;
import com.cc.infosur.main.MainActivity;
import com.cc.infosur.mytrip.ImageFullScreenFragment;


import android.content.pm.ActivityInfo;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.text.method.ScrollingMovementMethod;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.GestureDetector;
import android.view.GestureDetector.OnGestureListener;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.GestureDetector.SimpleOnGestureListener;
import android.view.View.OnClickListener;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

public class InfoFragment extends Fragment {
	private ImageView goToDayButton;
	private TextView textDescription;
	private TextView textNameService;
	private ImageView imageDescription;
	private LinearLayout pageIndicatorLayout;

	private int descriptionNo;
	private String name = "";
	private List<Detail> detail;
	private ArrayList<String> images;

	public MainActivity mActivity;

	private GestureDetector gestureDetector;
	View.OnTouchListener gestureListener;



	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
		System.out.println("------------- CONFIGURATION CHANGE ! -----------");
		// Reload current fragment
		final FragmentTransaction ft = getFragmentManager().beginTransaction();
		ft.detach(this);
		ft.attach(this);
		ft.commit();
	}


	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		View V = inflater.inflate(R.layout.info, container, false);

		System.out.println("Fragment crée !");

		// Gesture detection
		gestureDetector = new GestureDetector(getActivity(),
				new MyGestureDetector());
		gestureListener = new View.OnTouchListener() {
			public boolean onTouch(View v, MotionEvent event) {
				return gestureDetector.onTouchEvent(event);
			}
		};

		V.setOnTouchListener(gestureListener);

		// ScrollView scrollView = (ScrollView)
		// V.findViewById(R.id.scrollViewDescription);
		// scrollView.setOnTouchListener(this);

		mActivity = (MainActivity) this.getActivity();

		pageIndicatorLayout = (LinearLayout) V
				.findViewById(R.id.pageIndicatorLayout);

		textDescription = (TextView) V.findViewById(R.id.textDescription);
		textDescription.setMovementMethod(new ScrollingMovementMethod());
		textDescription.setOnTouchListener(gestureListener);

		textNameService = (TextView) V.findViewById(R.id.textNameService);
		textNameService.setText(name);

		imageDescription = (ImageView) V.findViewById(R.id.sentImageView);

		imageDescription.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View view) {
				Log.e("CLICK", "IMAGE "+descriptionNo);
				FragmentTransaction ft = mActivity.getSupportFragmentManager().beginTransaction();
				ImageFullScreenFragment imageFullScreenFragment = new ImageFullScreenFragment();
				imageFullScreenFragment.setPicture(detail.get(descriptionNo).getPicture());

				ft.replace(R.id.root_fragment, imageFullScreenFragment);
				ft.addToBackStack(null);
				ft.commit();
			}
		});

		goToDayButton = (ImageView) V.findViewById(R.id.goToDayButton);
		goToDayButton.setOnClickListener(goToDayListener);

        // Show dots
        showPageIndicatorDots();

        // Initialize description
        initializeDescription();

		//getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);

		return V;
	}

	@Override
	public void onDestroy(){
		super.onDestroy();
		//getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
	}


    /**
     * Onclick goToDayListener
     */
	private OnClickListener goToDayListener = new View.OnClickListener() {
		@Override
		public void onClick(View v) {
			//mActivity.popFragments();
			getFragmentManager().popBackStack();
		}
	};

	public void setName(String n) {
		this.name = n;
	}

	public void setDescriptionNo(int n) {
		this.descriptionNo = n;
	}
	
	public int getDescriptionNo(){
		return this.descriptionNo;
	}

	public void setDetails(List<Detail> d) {
		this.detail = d;
	}

	private void initializeDescription() {


        //if(detail.size() > 0) {

            // System.out.println(" ****** detail ***** " + detail);
            // System.out.println(" ****** detail.size ***** " + detail.size());
            // System.out.println(" ****** detail.get(0) ***** " + detail.get(0));
            // System.out.println(" ****** descriptionNo ***** " + descriptionNo);
            // System.out.println(" ****** INFO FRAGMENT :: DESCRIPTION ****** " + detail.get(descriptionNo).getFulldescr());

            for (int i = 0 ; i < detail.size() ; i++) {
                System.out.println(" ****** detail.get("+i+") ***** " + detail.get(i).getFulldescr());
            }

            System.out.println(" *********** ");

            //System.out.println(" ****** detail.get(0) ***** " + detail.get(0).getFulldescr());
            //System.out.println(" ****** detail.get(0) ***** " + detail.get(1).getFulldescr());



            showPageIndicatorDots();

            textDescription.setText(detail.get(descriptionNo).getFulldescr());

            Bitmap bmp = BitmapFactory
                    .decodeByteArray(detail.get(descriptionNo).getPicture(), 0,
                            detail.get(descriptionNo).getPicture().length);
            imageDescription.setImageBitmap(bmp);



	}

	private void showPageIndicatorDots() {
		pageIndicatorLayout.removeAllViews();
		ImageView iv;
		for (int i = 0; i < detail.size(); i++) {
			iv = new ImageView(getActivity());
			if (i == descriptionNo)
				iv.setImageDrawable(getResources().getDrawable(
						R.drawable.dot_green));
			else
				iv.setImageDrawable(getResources().getDrawable(
						R.drawable.dot_grey));
			pageIndicatorLayout.addView(iv);
		}
	}

	private class MyGestureDetector extends SimpleOnGestureListener {

		private static final int SWIPE_MIN_DISTANCE = 120;
		private static final int SWIPE_MAX_OFF_PATH = 250;
		private static final int SWIPE_THRESHOLD_VELOCITY = 200;

		@Override
		public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX,
				float velocityY) {
			try {
				if (Math.abs(e1.getY() - e2.getY()) > SWIPE_MAX_OFF_PATH)
					return false;
				// right to left swipe
				if (e1.getX() - e2.getX() > SWIPE_MIN_DISTANCE
						&& Math.abs(velocityX) > SWIPE_THRESHOLD_VELOCITY) {
					Log.i("DOTS", "SWIPE RIGHT");
					if (descriptionNo < detail.size() - 1) {
						setDescriptionNo(getDescriptionNo() + 1);
						initializeDescription();
					}
				} else if (e2.getX() - e1.getX() > SWIPE_MIN_DISTANCE
						&& Math.abs(velocityX) > SWIPE_THRESHOLD_VELOCITY) {
					if (descriptionNo > 0) {
						setDescriptionNo(getDescriptionNo() - 1);
						initializeDescription();
					}
				}
			} catch (Exception e) {
				// nothing
			}
			return false;
		}

		@Override
		public boolean onDown(MotionEvent e) {
			return true;
		}
	}


}
