package com.cc.infosur.map;

import java.util.List;
import com.cc.infosur.R;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class HeritageSpinnerAdapter extends ArrayAdapter<String> {
    private final Context context;
    private final List<String> values;

    public HeritageSpinnerAdapter(Context context, List<String> values) {
        super(context, R.layout.rowlayout, values);
        this.context = context;
        this.values = values;
    }

    @Override
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        LayoutInflater inflater = (LayoutInflater) context
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View rowView = inflater.inflate(R.layout.rowlayout, parent, false);
        TextView textView = (TextView) rowView.findViewById(R.id.spinnerText);
        textView.setText(values.get(position));
        return rowView;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        LayoutInflater inflater = (LayoutInflater) context
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View rowView = inflater.inflate(R.layout.selectedrowlayout, parent, false);
        TextView textView = (TextView) rowView.findViewById(R.id.spinnerText);
        textView.setText(values.get(position));

        return rowView;
    }
} 