package com.cc.infosur.map;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.cc.infosur.R;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.cc.infosur.greendao.DaoMaster;
import com.cc.infosur.greendao.DaoSession;
import com.cc.infosur.greendao.DayDao;
import com.cc.infosur.greendao.Detail;
import com.cc.infosur.greendao.Service;
import com.cc.infosur.greendao.ServiceDao;
import com.cc.infosur.greendao.Trip;
import com.cc.infosur.greendao.TripDao;
import com.cc.infosur.greendao.DaoMaster.DevOpenHelper;
import com.cc.infosur.main.MainActivity;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.content.res.AssetManager;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnKeyListener;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

public class HabitatFragment extends Fragment {
	private ImageButton goToDayButton;
	private ImageButton prevDescriptionButton;
	private ImageButton nextDescriptionButton;
	private TextView textDescription;
	private TextView textDay;
	private TextView textNameService;
	private TextView textDescriptionNo;
	private ImageView imageDescription;

	private long dayId;
	private long serviceId;
	private int descriptionNo;
	private String name;
	private List<Detail> detail;
	private ArrayList<String> images;
	
    private SQLiteDatabase db;
    private DevOpenHelper helper;
    private DaoSession daoSession;
    private DaoMaster daoMaster;
    private DayDao dayDao;
    private ServiceDao serviceDao;

    public MainActivity mActivity;
    
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
        View V = inflater.inflate(R.layout.habitat, container, false);
        
        mActivity =	(MainActivity) this.getActivity();
        
        textDescription = (TextView) V.findViewById(R.id.textHabitatDescr);
        
        imageDescription = (ImageView) V.findViewById(R.id.imageViewHabitat);
        
		//Prepare db
//        helper = new DaoMaster.DevOpenHelper(getActivity(), "tripdb", null);
//        db = helper.getWritableDatabase();
//        daoMaster = new DaoMaster(db);
//        daoSession = daoMaster.newSession();
//        dayDao = daoSession.getDayDao();
//        serviceDao = daoSession.getServiceDao();
//        
//	 	SimpleDateFormat  dateFormat = new SimpleDateFormat("yyyy-MM-dd");  
//
//        textDay.setText(dateFormat.format(dayDao.load(dayId).getDay()));
//        
//        Service service = serviceDao.load(serviceId);
//        textNameService.setText(service.getName());
//        
//        detail = service.getDetails();
        
//        initializeDescription();
        
        return V;
	}
	
	
	
	 private OnClickListener goToDayListener = new View.OnClickListener(){
	     @Override
	     public void onClick(View v){
	    	 //mActivity.popFragments();
	     }
	 };
	 
	 public void setDayId(long n){
		 this.dayId = n;
	 }
	 
	 public long getDayId(){
		 return this.dayId;
	 }
	 
	 public void setServiceId(long n){
		 this.serviceId = n;
	 }
	 
	 public long getServiceId(){
		 return this.serviceId;
	 }
	 
	 public void setDescriptionNo(int n){
		 this.descriptionNo = n;
	 }
	 
	 public int getDescriptionNo(){
		 return this.descriptionNo;
	 }
	 
	 private void initializeDescription(){       

            System.out.println(" ****** HABITAT FRAGMENT :: DESCRIPTION ****** " + detail.get(descriptionNo).getFulldescr());

	        textDescriptionNo.setText(Integer.toString(descriptionNo+1) + "/" + Integer.toString(detail.size()));
	        
	        if (descriptionNo == detail.size()-1){
	        	nextDescriptionButton.setEnabled(false);
	        }
	        else{
	        	nextDescriptionButton.setEnabled(true);
	        }
	        
	    	if(descriptionNo == 0){
	    		 prevDescriptionButton.setEnabled(false);
	    	}
	    	else{
	    		 prevDescriptionButton.setEnabled(true);
	    	}

	    	textDescription.setText(detail.get(descriptionNo).getFulldescr());
	        	        
            Bitmap bmp = BitmapFactory.decodeByteArray(detail.get(descriptionNo).getPicture(), 0, detail.get(descriptionNo).getPicture().length);
            imageDescription.setImageBitmap(bmp);
	        
	 }
}
