package com.cc.infosur.map;

import java.util.List;
import com.cc.infosur.R;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class FloraSpinnerAdapter extends ArrayAdapter<String> {
    private final Context context;
    private final List<String> values;

    private final List<byte[]> pictures;


    public FloraSpinnerAdapter(Context context, List<String> values, List<byte[]> pictures) {
        super(context, R.layout.rowlayout, values);
        this.context = context;
        this.values = values;
        this.pictures = pictures;
    }

    @Override
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        LayoutInflater inflater = (LayoutInflater) context
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View rowView = inflater.inflate(R.layout.rowlayout, parent, false);
        TextView textView = (TextView) rowView.findViewById(R.id.spinnerText);
        textView.setText(values.get(position));

        byte[] img = pictures.get(position);


        ImageView iv = (ImageView) rowView.findViewById(R.id.spinnerImage);
        if(img.length > 5){
            try {
            Bitmap bmp = BitmapFactory.decodeByteArray(img, 0, img.length);
            Bitmap bmp2 = Bitmap.createScaledBitmap(bmp, 150, 100, true);
            iv.setImageBitmap(bmp2);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }else{
            Bitmap bmp2 = BitmapFactory.decodeByteArray(img, 0, img.length);
            iv.setImageBitmap(bmp2);
        }
        // Bitmap bmp2 = Bitmap.createScaledBitmap(bmp, 100, 100, tru


        return rowView;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        LayoutInflater inflater = (LayoutInflater) context
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View rowView = inflater.inflate(R.layout.selectedrowlayout, parent, false);
        TextView textView = (TextView) rowView.findViewById(R.id.spinnerText);
        textView.setText(values.get(position));

        return rowView;
    }
} 