/*
 * TripListAdapter.java
 * Custom adapter for the list view of the trips list
 */

package com.cc.infosur.main;

import java.text.SimpleDateFormat;
import java.util.List;

import com.cc.infosur.greendao.TripInfo;

import com.cc.infosur.R;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class TripListAdapter extends ArrayAdapter<TripInfo> {

	Context context;
	List<TripInfo> items;
	TripListActivity tripListActivity;
	
	public TripListAdapter(Context context, int textViewResourceId) {
		super(context, textViewResourceId);
	}

	public TripListAdapter(Context context, int resource,
			List<TripInfo> items) {
		super(context, resource, items);
		this.context = context;
		tripListActivity = (TripListActivity) context;
		this.items = items;
	}

	@Override
	public View getView(final int position, View convertView, ViewGroup parent) {



        View v = convertView;

        try {

		LayoutInflater vi;
		vi = LayoutInflater.from(getContext());

		v = vi.inflate(R.layout.triplistrowlayout, null);		

		// Displays the trip name and date
		TextView textView = (TextView) v.findViewById(R.id.tripName);
		textView.setText(items.get(position).getName());
        
		SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d");
		
		textView = (TextView) v.findViewById(R.id.tripDateFrom);
		textView.setText(dateFormat.format(items.get(position).getDateFrom()));

		/*textView = (TextView) v.findViewById(R.id.tripDateTo);
		textView.setText(dateFormat.format(items.get(position).getDateTo())); */
		
		// ClickListener which calls the parse json task: DownloadFilesTask
		v.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View arg0) {
				MainActivity.setTripId(items.get(position).getId().intValue());
				Log.i("TripListAdapter::setOnClickListener::TripID::", String.valueOf(items.get(position).getId().intValue()) + " :: Json :: " + items.get(position).getJson() ) ;
				new DownloadFilesTask(tripListActivity, items.get(position).getJson()).execute();
			}
			
		});


    } catch (Exception e) {
        e.printStackTrace();
    }

		return v;
	}

}