/*
 * MockLocationProvider.java
 * Mock location provider that simulates fake locations
 */

package com.cc.infosur.main;

import java.util.ArrayList;
import java.util.List;

import android.location.Criteria;
import android.location.Location;
import android.location.LocationManager;
import android.os.SystemClock;

public class MockLocationProvider extends Thread {

    private LocationManager locationManager;
    private String mocLocationProvider;
    private List<Double> latitudes;
    private List<Double> longitudes;

    private static Double latitude;
    private static Double longitude;

    public MockLocationProvider(LocationManager locationManager, String mocLocationProvider) {

        this.locationManager = locationManager;
        this.mocLocationProvider = mocLocationProvider;

        latitudes = new ArrayList<Double>() {{
            add(-26.477814256843534);
            add(-26.477790248198538);
            add(-26.47753575625352);
            add(-26.47683950182852);
            add(-26.476700250437815);
            add(-26.476431350723573);
            add(-26.476287297046664);
            add(-26.475893549409385);
            add(-26.475735089614073);
            add(-26.475629449629253);
            add(-26.475456583990326);
            add(-26.475355745580995);
            add(-26.47520208688253);
            add(-26.475106050091746);
            add(-26.47502922060141);
            add(-26.474942787363457);
            add(-26.474832344798212);
            add(-26.474760316981165);
            add(-26.474654676101245);
            add(-26.47459225189934);
            add(-26.477948705162902);
            add(-26.474798731822553);
            add(-26.47295480496774);
        }};
        longitudes = new ArrayList<Double>() {{
            add(20.61260998249054);
            add(20.6126207113266);
            add(20.612679719924927);
            add(20.61285138130188);
            add(20.61288893222809);
            add(20.612947940826416);
            add(20.612969398498535);
            add(20.61306059360504);
            add(20.61308741569519);
            add(20.61310350894928);
            add(20.61314105987549);
            add(20.613167881965637);
            add(20.613210797309875);
            add(20.613226890563965);
            add(20.613242983818054);
            add(20.613264441490173);
            add(20.61335027217865);
            add(20.613462924957275);
            add(20.613436102867126);
            add(20.613318085670468);
            add(20.613784790039062);
            add(20.614900588989258);
            add(20.614900588989258);
        }};
    }

    @Override
    public void run() {

        int i=0;
        while (true) {

            try {

                Thread.sleep(1000);

            } catch (InterruptedException e) {

                e.printStackTrace();
            }

            Location location = new Location(mocLocationProvider);

            try {
                // location.setLatitude(location.getLatitude());
                // location.setLongitude(location.getLongitude());
                location.setLatitude(latitude);
                location.setLongitude(longitude);
            } catch (Exception e) {
                //e.printStackTrace();
            }

            location.setAltitude(0);
            location.setAccuracy(10);

            // set the time in the location. If the time on this location
            // matches the time on the one in the previous set call, it will be
            // ignored
            location.setTime(System.currentTimeMillis());

            if(android.os.Build.VERSION.SDK_INT >= 17) {
                location.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
            }

            if (location != null) {
                locationManager.setTestProviderLocation(mocLocationProvider, location);
            }

        }
    }


    public static void setLatitude(Double latitud) {
        latitude = latitud;
    }


    public static void setLongitude(Double longitud) {
        longitude = longitud;
    }


    public static Double getLatitude() {
        return latitude;
    }


    public static Double getLongitude() {
        return longitude;
    }


}