package com.cc.infosur.main;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import android.util.JsonReader;

import com.cc.infosur.greendao.DbPoint;
import com.cc.infosur.greendao.DbPointDao;
import com.cc.infosur.greendao.DbPolygon;
import com.cc.infosur.greendao.DbPolygonDao;
import com.cc.infosur.greendao.ParkInfoDao;

public class GetMapLayer {

	int category;
	DbPointDao pointDao;
	DbPolygonDao polygonDao;
	ParkInfoDao parkInfoDao;
//	SightingDao sightingDao;
	long categoryId; //0:flora 1:fauna 2:heritage 3:park_limits 5: sighting 

	public GetMapLayer(int category, long categoryId, DbPointDao pointDao, DbPolygonDao polygonDao, ParkInfoDao parkInfoDao) {

        System.out.println(" ------ SENSA :: getMapLayer CLASS :: ");
        this.category = category;
		this.pointDao = pointDao;
		this.polygonDao = polygonDao;
		this.parkInfoDao = parkInfoDao;
		this.categoryId = categoryId;
//		this.sightingDao = sightingDao;
	}
	
	public void setCategory(int category){
		this.category = category;
	}

	void addPoint(double latitude, double longitude, int cat, long id) {
		DbPoint point = new DbPoint();
		point.setLatitude(latitude);
		point.setLongitude(longitude);
		if (cat == 0)
			point.setFloraId(id);
		if (cat == 4)
			point.setPolygonId(id);
//		if (cat == 5)
//			point.setSightingId(id);
		pointDao.insert(point);
	}
	
	long addPolygon (int cat, long id) {	
		DbPolygon polygon = new DbPolygon();
//		polygon.setId(polygonDao.count());
		if (cat == 0)
			polygon.setFloraId(id);
		else if (cat == 1)
			polygon.setFaunaId(id);
		else if (cat == 2)
			polygon.setHeritageId(id);
		else if (cat == 4)
			polygon.setParkInfoRestrictedId(id);
		else if (cat == 5)
			polygon.setParkInfoAccommodationId(id);
		return polygonDao.insert(polygon);
//		return polygon.getId();
	}

	boolean readJsonStream(InputStream in) throws IOException {
		JsonReader reader = new JsonReader(new InputStreamReader(in, "UTF-8"));

		reader.beginObject();
		while (reader.hasNext()) {
			String name = reader.nextName();
			if (name.equals("features")) {
				if (!readFeaturesArray(reader))
					return false;
			} else {
				reader.skipValue();
			}
		}
		reader.endObject();
		reader.close();
		return true;
	}

	boolean readFeaturesArray(JsonReader reader) throws IOException {
		reader.beginArray();
		while (reader.hasNext()) {
			if (!readFeature(reader))
				return false;
		}
		reader.endArray();
		return true;
	}

	boolean readFeature(JsonReader reader) throws IOException {
		reader.beginObject();
		while (reader.hasNext()) {
			String name = reader.nextName();
			if (name.equals("geometry")) {
				if (!readGeometry(reader))
					return false;
			} else {
				reader.skipValue();
			}
		}
		reader.endObject();
		return true;
	}

	boolean readGeometry(JsonReader reader) throws IOException {
		int type = 0;
		
		reader.beginObject();
		while (reader.hasNext()) {
			String name = reader.nextName();
			if (name.equals("type")) {
				String geoType = reader.nextString();
				if (geoType.equals("Point"))
					type = 0; //point
				else if (geoType.equals("MultiPolygon"))
					type = 1; //multipolygon
				else
					return false;
			} else if (name.equals("coordinates")) {
				if (type == 0){
					List<Double> point = readPoint(reader);
					addPoint(point.get(1), point.get(0), category, categoryId);
				}
				else{
					readPolygon(reader);
				}
			} else {
				reader.skipValue();
			}
		}
		reader.endObject();

		return true;
	}
	
	void readPolygon(JsonReader reader) throws IOException {
		
		long id = addPolygon(category, categoryId);
		DbPolygon polygon = polygonDao.load(id);
		
		reader.beginArray();
		reader.beginArray();
		reader.beginArray();
		while (reader.hasNext()){
			List<Double> point = readPoint(reader);
			addPoint(point.get(1), point.get(0), 4, id);
		}
		reader.endArray();
		while (reader.hasNext()){
			reader.skipValue();
		}
		reader.endArray();
		while (reader.hasNext()){
			reader.skipValue();
		}
		reader.endArray();

		polygonDao.update(polygon);
		if (category == 3)
			parkInfoDao.load(categoryId).setBoundary(polygon);
	}

	List<Double> readPoint(JsonReader reader) throws IOException {
		List<Double> geo = new ArrayList<Double>();

		reader.beginArray();
		while (reader.hasNext()) {
			geo.add(reader.nextDouble());
		}
		reader.endArray();

		return geo;
	}

}
