package com.cc.infosur.greendao;

import java.util.List;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table USER_PICTURES.
*/
public class UserPicturesDao extends AbstractDao<UserPictures, Long> {

    public static final String TABLENAME = "USER_PICTURES";

    /**
     * Properties of entity UserPictures.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Label = new Property(1, String.class, "label", false, "LABEL");
        public final static Property Comment = new Property(2, String.class, "comment", false, "COMMENT");
        public final static Property FullPath = new Property(3, String.class, "fullPath", false, "FULL_PATH");
        public final static Property TakeDate = new Property(4, java.util.Date.class, "takeDate", false, "TAKE_DATE");
        public final static Property Latitude = new Property(5, Double.class, "latitude", false, "LATITUDE");
        public final static Property Longitude = new Property(6, Double.class, "longitude", false, "LONGITUDE");
        public final static Property TripId = new Property(7, long.class, "tripId", false, "TRIP_ID");
    };

    private Query<UserPictures> trip_UserPicturesQuery;

    public UserPicturesDao(DaoConfig config) {
        super(config);
    }
    
    public UserPicturesDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'USER_PICTURES' (" + //
                "'_id' INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "'LABEL' TEXT," + // 1: label
                "'COMMENT' TEXT," + // 2: comment
                "'FULL_PATH' TEXT," + // 3: fullPath
                "'TAKE_DATE' INTEGER," + // 4: takeDate
                "'LATITUDE' REAL," + // 5: latitude
                "'LONGITUDE' REAL," + // 6: longitude
                "'TRIP_ID' INTEGER NOT NULL );"); // 7: tripId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'USER_PICTURES'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, UserPictures entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        String label = entity.getLabel();
        if (label != null) {
            stmt.bindString(2, label);
        }
 
        String comment = entity.getComment();
        if (comment != null) {
            stmt.bindString(3, comment);
        }
 
        String fullPath = entity.getFullPath();
        if (fullPath != null) {
            stmt.bindString(4, fullPath);
        }
 
        java.util.Date takeDate = entity.getTakeDate();
        if (takeDate != null) {
            stmt.bindLong(5, takeDate.getTime());
        }
 
        Double latitude = entity.getLatitude();
        if (latitude != null) {
            stmt.bindDouble(6, latitude);
        }
 
        Double longitude = entity.getLongitude();
        if (longitude != null) {
            stmt.bindDouble(7, longitude);
        }
        stmt.bindLong(8, entity.getTripId());
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public UserPictures readEntity(Cursor cursor, int offset) {
        UserPictures entity = new UserPictures( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), // label
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // comment
            cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), // fullPath
            cursor.isNull(offset + 4) ? null : new java.util.Date(cursor.getLong(offset + 4)), // takeDate
            cursor.isNull(offset + 5) ? null : cursor.getDouble(offset + 5), // latitude
            cursor.isNull(offset + 6) ? null : cursor.getDouble(offset + 6), // longitude
            cursor.getLong(offset + 7) // tripId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, UserPictures entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setLabel(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setComment(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setFullPath(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setTakeDate(cursor.isNull(offset + 4) ? null : new java.util.Date(cursor.getLong(offset + 4)));
        entity.setLatitude(cursor.isNull(offset + 5) ? null : cursor.getDouble(offset + 5));
        entity.setLongitude(cursor.isNull(offset + 6) ? null : cursor.getDouble(offset + 6));
        entity.setTripId(cursor.getLong(offset + 7));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(UserPictures entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(UserPictures entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "userPictures" to-many relationship of Trip. */
    public List<UserPictures> _queryTrip_UserPictures(long tripId) {
        synchronized (this) {
            if (trip_UserPicturesQuery == null) {
                QueryBuilder<UserPictures> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.TripId.eq(null));
                queryBuilder.orderRaw("TAKE_DATE ASC");
                trip_UserPicturesQuery = queryBuilder.build();
            }
        }
        Query<UserPictures> query = trip_UserPicturesQuery.forCurrentThread();
        query.setParameter(0, tripId);
        return query.list();
    }

}
