package com.cc.infosur.greendao;

import java.util.List;
import java.util.ArrayList;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table TRIP_INFO.
*/
public class TripInfoDao extends AbstractDao<TripInfo, Long> {

    public static final String TABLENAME = "TRIP_INFO";

    /**
     * Properties of entity TripInfo.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Name = new Property(1, String.class, "name", false, "NAME");
        public final static Property DateFrom = new Property(2, java.util.Date.class, "dateFrom", false, "DATE_FROM");
        public final static Property DateTo = new Property(3, java.util.Date.class, "dateTo", false, "DATE_TO");
        public final static Property Json = new Property(4, String.class, "json", false, "JSON");
        public final static Property UserInfoId = new Property(5, long.class, "userInfoId", false, "USER_INFO_ID");
    };

    private DaoSession daoSession;

    private Query<TripInfo> travellerInfo_TripsQuery;

    public TripInfoDao(DaoConfig config) {
        super(config);
    }
    
    public TripInfoDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'TRIP_INFO' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'NAME' TEXT," + // 1: name
                "'DATE_FROM' INTEGER," + // 2: dateFrom
                "'DATE_TO' INTEGER," + // 3: dateTo
                "'JSON' TEXT," + // 4: json
                "'USER_INFO_ID' INTEGER NOT NULL );"); // 5: userInfoId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'TRIP_INFO'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, TripInfo entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(2, name);
        }
 
        java.util.Date dateFrom = entity.getDateFrom();
        if (dateFrom != null) {
            stmt.bindLong(3, dateFrom.getTime());
        }
 
        java.util.Date dateTo = entity.getDateTo();
        if (dateTo != null) {
            stmt.bindLong(4, dateTo.getTime());
        }
 
        String json = entity.getJson();
        if (json != null) {
            stmt.bindString(5, json);
        }
        stmt.bindLong(6, entity.getUserInfoId());
    }

    @Override
    protected void attachEntity(TripInfo entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public TripInfo readEntity(Cursor cursor, int offset) {
        TripInfo entity = new TripInfo( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), // name
            cursor.isNull(offset + 2) ? null : new java.util.Date(cursor.getLong(offset + 2)), // dateFrom
            cursor.isNull(offset + 3) ? null : new java.util.Date(cursor.getLong(offset + 3)), // dateTo
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // json
            cursor.getLong(offset + 5) // userInfoId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, TripInfo entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setName(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setDateFrom(cursor.isNull(offset + 2) ? null : new java.util.Date(cursor.getLong(offset + 2)));
        entity.setDateTo(cursor.isNull(offset + 3) ? null : new java.util.Date(cursor.getLong(offset + 3)));
        entity.setJson(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setUserInfoId(cursor.getLong(offset + 5));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(TripInfo entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(TripInfo entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "trips" to-many relationship of TravellerInfo. */
    public List<TripInfo> _queryTravellerInfo_Trips(long userInfoId) {
        synchronized (this) {
            if (travellerInfo_TripsQuery == null) {
                QueryBuilder<TripInfo> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.UserInfoId.eq(null));
                queryBuilder.orderRaw("DATE_FROM ASC");
                travellerInfo_TripsQuery = queryBuilder.build();
            }
        }
        Query<TripInfo> query = travellerInfo_TripsQuery.forCurrentThread();
        query.setParameter(0, userInfoId);
        return query.list();
    }

    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getTravellerInfoDao().getAllColumns());
            builder.append(" FROM TRIP_INFO T");
            builder.append(" LEFT JOIN TRAVELLER_INFO T0 ON T.'USER_INFO_ID'=T0.'_id'");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }
    
    protected TripInfo loadCurrentDeep(Cursor cursor, boolean lock) {
        TripInfo entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        TravellerInfo travellerInfo = loadCurrentOther(daoSession.getTravellerInfoDao(), cursor, offset);
         if(travellerInfo != null) {
            entity.setTravellerInfo(travellerInfo);
        }

        return entity;    
    }

    public TripInfo loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();
        
        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);
        
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }
    
    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<TripInfo> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<TripInfo> list = new ArrayList<TripInfo>(count);
        
        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }
    
    protected List<TripInfo> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }
    

    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<TripInfo> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }
 
}
