package com.cc.infosur.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table TRIP.
*/
public class TripDao extends AbstractDao<Trip, Long> {

    public static final String TABLENAME = "TRIP";

    /**
     * Properties of entity Trip.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Version = new Property(1, Integer.class, "version", false, "VERSION");
        public final static Property Name = new Property(2, String.class, "name", false, "NAME");
        public final static Property DateFrom = new Property(3, java.util.Date.class, "dateFrom", false, "DATE_FROM");
        public final static Property DateTo = new Property(4, java.util.Date.class, "dateTo", false, "DATE_TO");
    };

    private DaoSession daoSession;


    public TripDao(DaoConfig config) {
        super(config);
    }
    
    public TripDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'TRIP' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'VERSION' INTEGER," + // 1: version
                "'NAME' TEXT," + // 2: name
                "'DATE_FROM' INTEGER," + // 3: dateFrom
                "'DATE_TO' INTEGER);"); // 4: dateTo
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'TRIP'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Trip entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Integer version = entity.getVersion();
        if (version != null) {
            stmt.bindLong(2, version);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(3, name);
        }
 
        java.util.Date dateFrom = entity.getDateFrom();
        if (dateFrom != null) {
            stmt.bindLong(4, dateFrom.getTime());
        }
 
        java.util.Date dateTo = entity.getDateTo();
        if (dateTo != null) {
            stmt.bindLong(5, dateTo.getTime());
        }
    }

    @Override
    protected void attachEntity(Trip entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public Trip readEntity(Cursor cursor, int offset) {
        Trip entity = new Trip( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1), // version
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // name
            cursor.isNull(offset + 3) ? null : new java.util.Date(cursor.getLong(offset + 3)), // dateFrom
            cursor.isNull(offset + 4) ? null : new java.util.Date(cursor.getLong(offset + 4)) // dateTo
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Trip entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setVersion(cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1));
        entity.setName(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setDateFrom(cursor.isNull(offset + 3) ? null : new java.util.Date(cursor.getLong(offset + 3)));
        entity.setDateTo(cursor.isNull(offset + 4) ? null : new java.util.Date(cursor.getLong(offset + 4)));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Trip entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(Trip entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
}
