package com.cc.infosur.greendao;

import java.util.List;
import java.util.ArrayList;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table SERVICE.
*/
public class ServiceDao extends AbstractDao<Service, Long> {

    public static final String TABLENAME = "SERVICE";

    /**
     * Properties of entity Service.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Idserviceepp = new Property(1, Long.class, "idserviceepp", false, "IDSERVICEEPP");
        public final static Property Name = new Property(2, String.class, "name", false, "NAME");
        public final static Property Locality = new Property(3, String.class, "locality", false, "LOCALITY");
        public final static Property Type = new Property(4, Integer.class, "type", false, "TYPE");
        public final static Property Latitude = new Property(5, Double.class, "latitude", false, "LATITUDE");
        public final static Property Longitude = new Property(6, Double.class, "longitude", false, "LONGITUDE");
        public final static Property StartHour = new Property(7, String.class, "startHour", false, "START_HOUR");
        public final static Property Icon = new Property(8, byte[].class, "icon", false, "ICON");
        public final static Property Available = new Property(9, Boolean.class, "available", false, "AVAILABLE");
        public final static Property Activated = new Property(10, Boolean.class, "activated", false, "ACTIVATED");
        public final static Property ServiceMap = new Property(11, Integer.class, "serviceMap", false, "SERVICE_MAP");
        public final static Property DayId = new Property(12, long.class, "dayId", false, "DAY_ID");
        public final static Property ExcursionId = new Property(13, long.class, "excursionId", false, "EXCURSION_ID");
        public final static Property AlternativeServiceId = new Property(14, long.class, "alternativeServiceId", false, "ALTERNATIVE_SERVICE_ID");
        public final static Property PolygonId = new Property(15, long.class, "polygonId", false, "POLYGON_ID");
    };

    private DaoSession daoSession;

    private Query<Service> day_ServicesQuery;
    private Query<Service> excursion_ServicesQuery;
    private Query<Service> service_AlternativeServicesQuery;

    public ServiceDao(DaoConfig config) {
        super(config);
    }
    
    public ServiceDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'SERVICE' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'IDSERVICEEPP' INTEGER," + // 1: idserviceepp
                "'NAME' TEXT," + // 2: name
                "'LOCALITY' TEXT," + // 3: locality
                "'TYPE' INTEGER," + // 4: type
                "'LATITUDE' REAL," + // 5: latitude
                "'LONGITUDE' REAL," + // 6: longitude
                "'START_HOUR' TEXT," + // 7: startHour
                "'ICON' BLOB," + // 8: icon
                "'AVAILABLE' INTEGER," + // 9: available
                "'ACTIVATED' INTEGER," + // 10: activated
                "'SERVICE_MAP' INTEGER," + // 11: serviceMap
                "'DAY_ID' INTEGER NOT NULL ," + // 12: dayId
                "'EXCURSION_ID' INTEGER NOT NULL ," + // 13: excursionId
                "'ALTERNATIVE_SERVICE_ID' INTEGER NOT NULL ," + // 14: alternativeServiceId
                "'POLYGON_ID' INTEGER NOT NULL );"); // 15: polygonId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'SERVICE'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Service entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long idserviceepp = entity.getIdserviceepp();
        if (idserviceepp != null) {
            stmt.bindLong(2, idserviceepp);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(3, name);
        }
 
        String locality = entity.getLocality();
        if (locality != null) {
            stmt.bindString(4, locality);
        }
 
        Integer type = entity.getType();
        if (type != null) {
            stmt.bindLong(5, type);
        }
 
        Double latitude = entity.getLatitude();
        if (latitude != null) {
            stmt.bindDouble(6, latitude);
        }
 
        Double longitude = entity.getLongitude();
        if (longitude != null) {
            stmt.bindDouble(7, longitude);
        }
 
        String startHour = entity.getStartHour();
        if (startHour != null) {
            stmt.bindString(8, startHour);
        }
 
        byte[] icon = entity.getIcon();
        if (icon != null) {
            stmt.bindBlob(9, icon);
        }
 
        Boolean available = entity.getAvailable();
        if (available != null) {
            stmt.bindLong(10, available ? 1l: 0l);
        }
 
        Boolean activated = entity.getActivated();
        if (activated != null) {
            stmt.bindLong(11, activated ? 1l: 0l);
        }
 
        Integer serviceMap = entity.getServiceMap();
        if (serviceMap != null) {
            stmt.bindLong(12, serviceMap);
        }
        stmt.bindLong(13, entity.getDayId());
        stmt.bindLong(14, entity.getExcursionId());
        stmt.bindLong(15, entity.getAlternativeServiceId());
        stmt.bindLong(16, entity.getPolygonId());
    }

    @Override
    protected void attachEntity(Service entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public Service readEntity(Cursor cursor, int offset) {
        Service entity = new Service( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // idserviceepp
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // name
            cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), // locality
            cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4), // type
            cursor.isNull(offset + 5) ? null : cursor.getDouble(offset + 5), // latitude
            cursor.isNull(offset + 6) ? null : cursor.getDouble(offset + 6), // longitude
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // startHour
            cursor.isNull(offset + 8) ? null : cursor.getBlob(offset + 8), // icon
            cursor.isNull(offset + 9) ? null : cursor.getShort(offset + 9) != 0, // available
            cursor.isNull(offset + 10) ? null : cursor.getShort(offset + 10) != 0, // activated
            cursor.isNull(offset + 11) ? null : cursor.getInt(offset + 11), // serviceMap
            cursor.getLong(offset + 12), // dayId
            cursor.getLong(offset + 13), // excursionId
            cursor.getLong(offset + 14), // alternativeServiceId
            cursor.getLong(offset + 15) // polygonId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Service entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setIdserviceepp(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setName(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setLocality(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setType(cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4));
        entity.setLatitude(cursor.isNull(offset + 5) ? null : cursor.getDouble(offset + 5));
        entity.setLongitude(cursor.isNull(offset + 6) ? null : cursor.getDouble(offset + 6));
        entity.setStartHour(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setIcon(cursor.isNull(offset + 8) ? null : cursor.getBlob(offset + 8));
        entity.setAvailable(cursor.isNull(offset + 9) ? null : cursor.getShort(offset + 9) != 0);
        entity.setActivated(cursor.isNull(offset + 10) ? null : cursor.getShort(offset + 10) != 0);
        entity.setServiceMap(cursor.isNull(offset + 11) ? null : cursor.getInt(offset + 11));
        entity.setDayId(cursor.getLong(offset + 12));
        entity.setExcursionId(cursor.getLong(offset + 13));
        entity.setAlternativeServiceId(cursor.getLong(offset + 14));
        entity.setPolygonId(cursor.getLong(offset + 15));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Service entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(Service entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "services" to-many relationship of Day. */
    public List<Service> _queryDay_Services(long dayId) {
        synchronized (this) {
            if (day_ServicesQuery == null) {
                QueryBuilder<Service> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.DayId.eq(null));
                day_ServicesQuery = queryBuilder.build();
            }
        }
        Query<Service> query = day_ServicesQuery.forCurrentThread();
        query.setParameter(0, dayId);
        return query.list();
    }

    /** Internal query to resolve the "services" to-many relationship of Excursion. */
    public List<Service> _queryExcursion_Services(long excursionId) {
        synchronized (this) {
            if (excursion_ServicesQuery == null) {
                QueryBuilder<Service> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.ExcursionId.eq(null));
                excursion_ServicesQuery = queryBuilder.build();
            }
        }
        Query<Service> query = excursion_ServicesQuery.forCurrentThread();
        query.setParameter(0, excursionId);
        return query.list();
    }

    /** Internal query to resolve the "alternativeServices" to-many relationship of Service. */
    public List<Service> _queryService_AlternativeServices(long alternativeServiceId) {
        synchronized (this) {
            if (service_AlternativeServicesQuery == null) {
                QueryBuilder<Service> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.AlternativeServiceId.eq(null));
                service_AlternativeServicesQuery = queryBuilder.build();
            }
        }
        Query<Service> query = service_AlternativeServicesQuery.forCurrentThread();
        query.setParameter(0, alternativeServiceId);
        return query.list();
    }

    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getExcursionDao().getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T1", daoSession.getDbPolygonDao().getAllColumns());
            builder.append(" FROM SERVICE T");
            builder.append(" LEFT JOIN EXCURSION T0 ON T.'EXCURSION_ID'=T0.'_id'");
            builder.append(" LEFT JOIN DB_POLYGON T1 ON T.'POLYGON_ID'=T1.'_id'");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }
    
    protected Service loadCurrentDeep(Cursor cursor, boolean lock) {
        Service entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        Excursion excursion = loadCurrentOther(daoSession.getExcursionDao(), cursor, offset);
         if(excursion != null) {
            entity.setExcursion(excursion);
        }
        offset += daoSession.getExcursionDao().getAllColumns().length;

        DbPolygon polygon = loadCurrentOther(daoSession.getDbPolygonDao(), cursor, offset);
         if(polygon != null) {
            entity.setPolygon(polygon);
        }

        return entity;    
    }

    public Service loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();
        
        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);
        
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }
    
    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<Service> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<Service> list = new ArrayList<Service>(count);
        
        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }
    
    protected List<Service> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }
    

    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<Service> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }
 
}
