package com.cc.infosur.greendao;

import java.util.List;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table QUESTION.
*/
public class QuestionDao extends AbstractDao<Question, Long> {

    public static final String TABLENAME = "QUESTION";

    /**
     * Properties of entity Question.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Selected = new Property(1, Boolean.class, "selected", false, "SELECTED");
        public final static Property Title = new Property(2, String.class, "title", false, "TITLE");
        public final static Property Quantity = new Property(3, Integer.class, "quantity", false, "QUANTITY");
        public final static Property PhotoSample = new Property(4, byte[].class, "photoSample", false, "PHOTO_SAMPLE");
        public final static Property PhotoThumb = new Property(5, byte[].class, "photoThumb", false, "PHOTO_THUMB");
        public final static Property PhotoPath = new Property(6, String.class, "photoPath", false, "PHOTO_PATH");
        public final static Property PhotoTaken = new Property(7, Boolean.class, "photoTaken", false, "PHOTO_TAKEN");
        public final static Property QuestionaryId = new Property(8, long.class, "questionaryId", false, "QUESTIONARY_ID");
    };

    private Query<Question> questionary_QuestionsQuery;

    public QuestionDao(DaoConfig config) {
        super(config);
    }
    
    public QuestionDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'QUESTION' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'SELECTED' INTEGER," + // 1: selected
                "'TITLE' TEXT," + // 2: title
                "'QUANTITY' INTEGER," + // 3: quantity
                "'PHOTO_SAMPLE' BLOB," + // 4: photoSample
                "'PHOTO_THUMB' BLOB," + // 5: photoThumb
                "'PHOTO_PATH' TEXT," + // 6: photoPath
                "'PHOTO_TAKEN' INTEGER," + // 7: photoTaken
                "'QUESTIONARY_ID' INTEGER NOT NULL );"); // 8: questionaryId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'QUESTION'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Question entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Boolean selected = entity.getSelected();
        if (selected != null) {
            stmt.bindLong(2, selected ? 1l: 0l);
        }
 
        String title = entity.getTitle();
        if (title != null) {
            stmt.bindString(3, title);
        }
 
        Integer quantity = entity.getQuantity();
        if (quantity != null) {
            stmt.bindLong(4, quantity);
        }
 
        byte[] photoSample = entity.getPhotoSample();
        if (photoSample != null) {
            stmt.bindBlob(5, photoSample);
        }
 
        byte[] photoThumb = entity.getPhotoThumb();
        if (photoThumb != null) {
            stmt.bindBlob(6, photoThumb);
        }
 
        String photoPath = entity.getPhotoPath();
        if (photoPath != null) {
            stmt.bindString(7, photoPath);
        }
 
        Boolean photoTaken = entity.getPhotoTaken();
        if (photoTaken != null) {
            stmt.bindLong(8, photoTaken ? 1l: 0l);
        }
        stmt.bindLong(9, entity.getQuestionaryId());
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public Question readEntity(Cursor cursor, int offset) {
        Question entity = new Question( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getShort(offset + 1) != 0, // selected
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // title
            cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3), // quantity
            cursor.isNull(offset + 4) ? null : cursor.getBlob(offset + 4), // photoSample
            cursor.isNull(offset + 5) ? null : cursor.getBlob(offset + 5), // photoThumb
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // photoPath
            cursor.isNull(offset + 7) ? null : cursor.getShort(offset + 7) != 0, // photoTaken
            cursor.getLong(offset + 8) // questionaryId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Question entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setSelected(cursor.isNull(offset + 1) ? null : cursor.getShort(offset + 1) != 0);
        entity.setTitle(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setQuantity(cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3));
        entity.setPhotoSample(cursor.isNull(offset + 4) ? null : cursor.getBlob(offset + 4));
        entity.setPhotoThumb(cursor.isNull(offset + 5) ? null : cursor.getBlob(offset + 5));
        entity.setPhotoPath(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setPhotoTaken(cursor.isNull(offset + 7) ? null : cursor.getShort(offset + 7) != 0);
        entity.setQuestionaryId(cursor.getLong(offset + 8));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Question entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(Question entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "questions" to-many relationship of Questionary. */
    public List<Question> _queryQuestionary_Questions(long questionaryId) {
        synchronized (this) {
            if (questionary_QuestionsQuery == null) {
                QueryBuilder<Question> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.QuestionaryId.eq(null));
                questionary_QuestionsQuery = queryBuilder.build();
            }
        }
        Query<Question> query = questionary_QuestionsQuery.forCurrentThread();
        query.setParameter(0, questionaryId);
        return query.list();
    }

}
