package com.cc.infosur.greendao;

import java.util.List;
import java.util.ArrayList;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.internal.DaoConfig;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table PARK_INFO.
*/
public class ParkInfoDao extends AbstractDao<ParkInfo, Long> {

    public static final String TABLENAME = "PARK_INFO";

    /**
     * Properties of entity ParkInfo.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property EtpParkId = new Property(1, Integer.class, "etpParkId", false, "ETP_PARK_ID");
        public final static Property EppParkId = new Property(2, Integer.class, "eppParkId", false, "EPP_PARK_ID");
        public final static Property Restricted = new Property(3, Boolean.class, "restricted", false, "RESTRICTED");
        public final static Property TimeoutTimefencingTraveller = new Property(4, Integer.class, "timeoutTimefencingTraveller", false, "TIMEOUT_TIMEFENCING_TRAVELLER");
        public final static Property TimeoutGeofencingTraveller = new Property(5, Integer.class, "timeoutGeofencingTraveller", false, "TIMEOUT_GEOFENCING_TRAVELLER");
        public final static Property TimeoutTripviolationTraveller = new Property(6, Integer.class, "timeoutTripviolationTraveller", false, "TIMEOUT_TRIPVIOLATION_TRAVELLER");
        public final static Property TimeoutTimefencingParkmanager = new Property(7, Integer.class, "timeoutTimefencingParkmanager", false, "TIMEOUT_TIMEFENCING_PARKMANAGER");
        public final static Property TimeoutGeofencingParkmanager = new Property(8, Integer.class, "timeoutGeofencingParkmanager", false, "TIMEOUT_GEOFENCING_PARKMANAGER");
        public final static Property TimeoutTripviolationParkmanager = new Property(9, Integer.class, "timeoutTripviolationParkmanager", false, "TIMEOUT_TRIPVIOLATION_PARKMANAGER");
        public final static Property BoundaryId = new Property(10, Long.class, "boundaryId", false, "BOUNDARY_ID");
    };

    private DaoSession daoSession;


    public ParkInfoDao(DaoConfig config) {
        super(config);
    }
    
    public ParkInfoDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'PARK_INFO' (" + //
                "'_id' INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "'ETP_PARK_ID' INTEGER," + // 1: etpParkId
                "'EPP_PARK_ID' INTEGER," + // 2: eppParkId
                "'RESTRICTED' INTEGER," + // 3: restricted
                "'TIMEOUT_TIMEFENCING_TRAVELLER' INTEGER," + // 4: timeoutTimefencingTraveller
                "'TIMEOUT_GEOFENCING_TRAVELLER' INTEGER," + // 5: timeoutGeofencingTraveller
                "'TIMEOUT_TRIPVIOLATION_TRAVELLER' INTEGER," + // 6: timeoutTripviolationTraveller
                "'TIMEOUT_TIMEFENCING_PARKMANAGER' INTEGER," + // 7: timeoutTimefencingParkmanager
                "'TIMEOUT_GEOFENCING_PARKMANAGER' INTEGER," + // 8: timeoutGeofencingParkmanager
                "'TIMEOUT_TRIPVIOLATION_PARKMANAGER' INTEGER," + // 9: timeoutTripviolationParkmanager
                "'BOUNDARY_ID' INTEGER);"); // 10: boundaryId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'PARK_INFO'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, ParkInfo entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Integer etpParkId = entity.getEtpParkId();
        if (etpParkId != null) {
            stmt.bindLong(2, etpParkId);
        }
 
        Integer eppParkId = entity.getEppParkId();
        if (eppParkId != null) {
            stmt.bindLong(3, eppParkId);
        }
 
        Boolean restricted = entity.getRestricted();
        if (restricted != null) {
            stmt.bindLong(4, restricted ? 1l: 0l);
        }
 
        Integer timeoutTimefencingTraveller = entity.getTimeoutTimefencingTraveller();
        if (timeoutTimefencingTraveller != null) {
            stmt.bindLong(5, timeoutTimefencingTraveller);
        }
 
        Integer timeoutGeofencingTraveller = entity.getTimeoutGeofencingTraveller();
        if (timeoutGeofencingTraveller != null) {
            stmt.bindLong(6, timeoutGeofencingTraveller);
        }
 
        Integer timeoutTripviolationTraveller = entity.getTimeoutTripviolationTraveller();
        if (timeoutTripviolationTraveller != null) {
            stmt.bindLong(7, timeoutTripviolationTraveller);
        }
 
        Integer timeoutTimefencingParkmanager = entity.getTimeoutTimefencingParkmanager();
        if (timeoutTimefencingParkmanager != null) {
            stmt.bindLong(8, timeoutTimefencingParkmanager);
        }
 
        Integer timeoutGeofencingParkmanager = entity.getTimeoutGeofencingParkmanager();
        if (timeoutGeofencingParkmanager != null) {
            stmt.bindLong(9, timeoutGeofencingParkmanager);
        }
 
        Integer timeoutTripviolationParkmanager = entity.getTimeoutTripviolationParkmanager();
        if (timeoutTripviolationParkmanager != null) {
            stmt.bindLong(10, timeoutTripviolationParkmanager);
        }
 
        Long boundaryId = entity.getBoundaryId();
        if (boundaryId != null) {
            stmt.bindLong(11, boundaryId);
        }
    }

    @Override
    protected void attachEntity(ParkInfo entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public ParkInfo readEntity(Cursor cursor, int offset) {
        ParkInfo entity = new ParkInfo( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1), // etpParkId
            cursor.isNull(offset + 2) ? null : cursor.getInt(offset + 2), // eppParkId
            cursor.isNull(offset + 3) ? null : cursor.getShort(offset + 3) != 0, // restricted
            cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4), // timeoutTimefencingTraveller
            cursor.isNull(offset + 5) ? null : cursor.getInt(offset + 5), // timeoutGeofencingTraveller
            cursor.isNull(offset + 6) ? null : cursor.getInt(offset + 6), // timeoutTripviolationTraveller
            cursor.isNull(offset + 7) ? null : cursor.getInt(offset + 7), // timeoutTimefencingParkmanager
            cursor.isNull(offset + 8) ? null : cursor.getInt(offset + 8), // timeoutGeofencingParkmanager
            cursor.isNull(offset + 9) ? null : cursor.getInt(offset + 9), // timeoutTripviolationParkmanager
            cursor.isNull(offset + 10) ? null : cursor.getLong(offset + 10) // boundaryId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, ParkInfo entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setEtpParkId(cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1));
        entity.setEppParkId(cursor.isNull(offset + 2) ? null : cursor.getInt(offset + 2));
        entity.setRestricted(cursor.isNull(offset + 3) ? null : cursor.getShort(offset + 3) != 0);
        entity.setTimeoutTimefencingTraveller(cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4));
        entity.setTimeoutGeofencingTraveller(cursor.isNull(offset + 5) ? null : cursor.getInt(offset + 5));
        entity.setTimeoutTripviolationTraveller(cursor.isNull(offset + 6) ? null : cursor.getInt(offset + 6));
        entity.setTimeoutTimefencingParkmanager(cursor.isNull(offset + 7) ? null : cursor.getInt(offset + 7));
        entity.setTimeoutGeofencingParkmanager(cursor.isNull(offset + 8) ? null : cursor.getInt(offset + 8));
        entity.setTimeoutTripviolationParkmanager(cursor.isNull(offset + 9) ? null : cursor.getInt(offset + 9));
        entity.setBoundaryId(cursor.isNull(offset + 10) ? null : cursor.getLong(offset + 10));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(ParkInfo entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(ParkInfo entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getDbPolygonDao().getAllColumns());
            builder.append(" FROM PARK_INFO T");
            builder.append(" LEFT JOIN DB_POLYGON T0 ON T.'BOUNDARY_ID'=T0.'_id'");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }
    
    protected ParkInfo loadCurrentDeep(Cursor cursor, boolean lock) {
        ParkInfo entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        DbPolygon boundary = loadCurrentOther(daoSession.getDbPolygonDao(), cursor, offset);
        entity.setBoundary(boundary);

        return entity;    
    }

    public ParkInfo loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();
        
        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);
        
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }
    
    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<ParkInfo> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<ParkInfo> list = new ArrayList<ParkInfo>(count);
        
        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }
    
    protected List<ParkInfo> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }
    

    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<ParkInfo> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }
 
}
