package com.cc.infosur.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/**
 * DAO for table OBSERVATION.
 */
public class ObservationDao extends AbstractDao<Observation, Long> {

    public static final String TABLENAME = "OBSERVATION";

    /**
     * Properties of entity Observation.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Selected = new Property(1, Boolean.class, "selected", false, "SELECTED");
        public final static Property Specie = new Property(2, String.class, "specie", false, "SPECIE");
        public final static Property Category = new Property(3, String.class, "category", false, "CATEGORY");
        public final static Property Quantity = new Property(4, Integer.class, "quantity", false, "QUANTITY");
        public final static Property PhotoThumb = new Property(5, byte[].class, "photoThumb", false, "PHOTO_THUMB");
        public final static Property PhotoPath = new Property(6, String.class, "photoPath", false, "PHOTO_PATH");
        public final static Property PhotoTaken = new Property(7, Boolean.class, "photoTaken", false, "PHOTO_TAKEN");
        public final static Property Share = new Property(8, Boolean.class, "share", false, "SHARE");
    };


    public ObservationDao(DaoConfig config) {
        super(config);
    }

    public ObservationDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'OBSERVATION' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'SELECTED' INTEGER," + // 1: selected
                "'SPECIE' TEXT," + // 2: specie
                "'CATEGORY' TEXT," + // 3: category
                "'QUANTITY' INTEGER," + // 4: quantity
                "'PHOTO_THUMB' BLOB," + // 5: photoThumb
                "'PHOTO_PATH' TEXT," + // 6: photoPath
                "'PHOTO_TAKEN' INTEGER," + // 7: photoTaken
                "'SHARE' INTEGER);"); // 8: share
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'OBSERVATION'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Observation entity) {
        stmt.clearBindings();

        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }

        Boolean selected = entity.getSelected();
        if (selected != null) {
            stmt.bindLong(2, selected ? 1l: 0l);
        }

        String specie = entity.getSpecie();
        if (specie != null) {
            stmt.bindString(3, specie);
        }

        String category = entity.getCategory();
        if (category != null) {
            stmt.bindString(4, category);
        }

        Integer quantity = entity.getQuantity();
        if (quantity != null) {
            stmt.bindLong(5, quantity);
        }

        byte[] photoThumb = entity.getPhotoThumb();
        if (photoThumb != null) {
            stmt.bindBlob(6, photoThumb);
        }

        String photoPath = entity.getPhotoPath();
        if (photoPath != null) {
            stmt.bindString(7, photoPath);
        }

        Boolean photoTaken = entity.getPhotoTaken();
        if (photoTaken != null) {
            stmt.bindLong(8, photoTaken ? 1l : 0l);
        }

        Boolean share = entity.getShare();
        if (share != null) {
            stmt.bindLong(9, share ? 1l: 0l);
        }
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }

    /** @inheritdoc */
    @Override
    public Observation readEntity(Cursor cursor, int offset) {
        Observation entity = new Observation( //
                cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
                cursor.isNull(offset + 1) ? null : cursor.getShort(offset + 1) != 0, // selected
                cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // specie
                cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), // category
                cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4), // quantity
                cursor.isNull(offset + 5) ? null : cursor.getBlob(offset + 5), // photoThumb
                cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // photoPath
                cursor.isNull(offset + 7) ? null : cursor.getShort(offset + 7)!= 0, // photoTake
                cursor.isNull(offset + 8) ? null : cursor.getShort(offset + 8) != 0 // share
        );
        return entity;
    }

    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Observation entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setSelected(cursor.isNull(offset + 1) ? null : cursor.getShort(offset + 1) != 0);
        entity.setSpecie(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setCategory(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setQuantity(cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4));
        entity.setPhotoThumb(cursor.isNull(offset + 5) ? null : cursor.getBlob(offset + 5));
        entity.setPhotoPath(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setPhotoTaken(cursor.isNull(offset + 7) ? null : cursor.getShort(offset + 7) != 0);
    }

    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Observation entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }

    /** @inheritdoc */
    @Override
    public Long getKey(Observation entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override
    protected boolean isEntityUpdateable() {
        return true;
    }

}
