package com.cc.infosur.greendao;

import java.util.List;
import java.util.ArrayList;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.internal.DaoConfig;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table NODE.
*/
public class NodeDao extends AbstractDao<Node, Long> {

    public static final String TABLENAME = "NODE";

    /**
     * Properties of entity Node.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Latitude = new Property(1, Double.class, "latitude", false, "LATITUDE");
        public final static Property Longitude = new Property(2, Double.class, "longitude", false, "LONGITUDE");
        public final static Property LinkForward = new Property(3, Long.class, "linkForward", false, "LINK_FORWARD");
        public final static Property PositionForward = new Property(4, Integer.class, "positionForward", false, "POSITION_FORWARD");
        public final static Property LinkBackward = new Property(5, Long.class, "linkBackward", false, "LINK_BACKWARD");
        public final static Property PositionBackward = new Property(6, Integer.class, "positionBackward", false, "POSITION_BACKWARD");
        public final static Property Distance = new Property(7, Double.class, "distance", false, "DISTANCE");
        public final static Property PreviousId = new Property(8, Long.class, "previousId", false, "PREVIOUS_ID");
    };

    private DaoSession daoSession;


    public NodeDao(DaoConfig config) {
        super(config);
    }
    
    public NodeDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'NODE' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'LATITUDE' REAL," + // 1: latitude
                "'LONGITUDE' REAL," + // 2: longitude
                "'LINK_FORWARD' INTEGER," + // 3: linkForward
                "'POSITION_FORWARD' INTEGER," + // 4: positionForward
                "'LINK_BACKWARD' INTEGER," + // 5: linkBackward
                "'POSITION_BACKWARD' INTEGER," + // 6: positionBackward
                "'DISTANCE' REAL," + // 7: distance
                "'PREVIOUS_ID' INTEGER);"); // 8: previousId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'NODE'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Node entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Double latitude = entity.getLatitude();
        if (latitude != null) {
            stmt.bindDouble(2, latitude);
        }
 
        Double longitude = entity.getLongitude();
        if (longitude != null) {
            stmt.bindDouble(3, longitude);
        }
 
        Long linkForward = entity.getLinkForward();
        if (linkForward != null) {
            stmt.bindLong(4, linkForward);
        }
 
        Integer positionForward = entity.getPositionForward();
        if (positionForward != null) {
            stmt.bindLong(5, positionForward);
        }
 
        Long linkBackward = entity.getLinkBackward();
        if (linkBackward != null) {
            stmt.bindLong(6, linkBackward);
        }
 
        Integer positionBackward = entity.getPositionBackward();
        if (positionBackward != null) {
            stmt.bindLong(7, positionBackward);
        }
 
        Double distance = entity.getDistance();
        if (distance != null) {
            stmt.bindDouble(8, distance);
        }
 
        Long previousId = entity.getPreviousId();
        if (previousId != null) {
            stmt.bindLong(9, previousId);
        }
    }

    @Override
    protected void attachEntity(Node entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public Node readEntity(Cursor cursor, int offset) {
        Node entity = new Node( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getDouble(offset + 1), // latitude
            cursor.isNull(offset + 2) ? null : cursor.getDouble(offset + 2), // longitude
            cursor.isNull(offset + 3) ? null : cursor.getLong(offset + 3), // linkForward
            cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4), // positionForward
            cursor.isNull(offset + 5) ? null : cursor.getLong(offset + 5), // linkBackward
            cursor.isNull(offset + 6) ? null : cursor.getInt(offset + 6), // positionBackward
            cursor.isNull(offset + 7) ? null : cursor.getDouble(offset + 7), // distance
            cursor.isNull(offset + 8) ? null : cursor.getLong(offset + 8) // previousId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Node entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setLatitude(cursor.isNull(offset + 1) ? null : cursor.getDouble(offset + 1));
        entity.setLongitude(cursor.isNull(offset + 2) ? null : cursor.getDouble(offset + 2));
        entity.setLinkForward(cursor.isNull(offset + 3) ? null : cursor.getLong(offset + 3));
        entity.setPositionForward(cursor.isNull(offset + 4) ? null : cursor.getInt(offset + 4));
        entity.setLinkBackward(cursor.isNull(offset + 5) ? null : cursor.getLong(offset + 5));
        entity.setPositionBackward(cursor.isNull(offset + 6) ? null : cursor.getInt(offset + 6));
        entity.setDistance(cursor.isNull(offset + 7) ? null : cursor.getDouble(offset + 7));
        entity.setPreviousId(cursor.isNull(offset + 8) ? null : cursor.getLong(offset + 8));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Node entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(Node entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getLinkDao().getAllColumns());
            builder.append(" FROM NODE T");
            builder.append(" LEFT JOIN LINK T0 ON T.'PREVIOUS_ID'=T0.'_id'");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }
    
    protected Node loadCurrentDeep(Cursor cursor, boolean lock) {
        Node entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        Link previous = loadCurrentOther(daoSession.getLinkDao(), cursor, offset);
        entity.setPrevious(previous);

        return entity;    
    }

    public Node loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();
        
        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);
        
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }
    
    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<Node> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<Node> list = new ArrayList<Node>(count);
        
        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }
    
    protected List<Node> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }
    

    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<Node> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }
 
}
