package com.cc.infosur.greendao;

import java.util.List;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table MONTH_OPENING_TIME.
*/
public class MonthOpeningTimeDao extends AbstractDao<MonthOpeningTime, Long> {

    public static final String TABLENAME = "MONTH_OPENING_TIME";

    /**
     * Properties of entity MonthOpeningTime.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property OpenFrom = new Property(1, java.util.Date.class, "openFrom", false, "OPEN_FROM");
        public final static Property OpenTo = new Property(2, java.util.Date.class, "openTo", false, "OPEN_TO");
        public final static Property ParkInfoId = new Property(3, long.class, "parkInfoId", false, "PARK_INFO_ID");
    };

    private Query<MonthOpeningTime> parkInfo_MonthsOpeningTimeQuery;

    public MonthOpeningTimeDao(DaoConfig config) {
        super(config);
    }
    
    public MonthOpeningTimeDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'MONTH_OPENING_TIME' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'OPEN_FROM' INTEGER," + // 1: openFrom
                "'OPEN_TO' INTEGER," + // 2: openTo
                "'PARK_INFO_ID' INTEGER NOT NULL );"); // 3: parkInfoId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'MONTH_OPENING_TIME'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, MonthOpeningTime entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        java.util.Date openFrom = entity.getOpenFrom();
        if (openFrom != null) {
            stmt.bindLong(2, openFrom.getTime());
        }
 
        java.util.Date openTo = entity.getOpenTo();
        if (openTo != null) {
            stmt.bindLong(3, openTo.getTime());
        }
        stmt.bindLong(4, entity.getParkInfoId());
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public MonthOpeningTime readEntity(Cursor cursor, int offset) {
        MonthOpeningTime entity = new MonthOpeningTime( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : new java.util.Date(cursor.getLong(offset + 1)), // openFrom
            cursor.isNull(offset + 2) ? null : new java.util.Date(cursor.getLong(offset + 2)), // openTo
            cursor.getLong(offset + 3) // parkInfoId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, MonthOpeningTime entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setOpenFrom(cursor.isNull(offset + 1) ? null : new java.util.Date(cursor.getLong(offset + 1)));
        entity.setOpenTo(cursor.isNull(offset + 2) ? null : new java.util.Date(cursor.getLong(offset + 2)));
        entity.setParkInfoId(cursor.getLong(offset + 3));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(MonthOpeningTime entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(MonthOpeningTime entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "monthsOpeningTime" to-many relationship of ParkInfo. */
    public List<MonthOpeningTime> _queryParkInfo_MonthsOpeningTime(long parkInfoId) {
        synchronized (this) {
            if (parkInfo_MonthsOpeningTimeQuery == null) {
                QueryBuilder<MonthOpeningTime> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.ParkInfoId.eq(null));
                parkInfo_MonthsOpeningTimeQuery = queryBuilder.build();
            }
        }
        Query<MonthOpeningTime> query = parkInfo_MonthsOpeningTimeQuery.forCurrentThread();
        query.setParameter(0, parkInfoId);
        return query.list();
    }

}
