package com.cc.infosur.greendao;

import java.util.List;
import java.util.ArrayList;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table LINK.
*/
public class LinkDao extends AbstractDao<Link, Long> {

    public static final String TABLENAME = "LINK";

    /**
     * Properties of entity Link.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Length = new Property(1, Double.class, "length", false, "LENGTH");
        public final static Property Speed = new Property(2, Double.class, "speed", false, "SPEED");
        public final static Property NodeFromId = new Property(3, long.class, "nodeFromId", false, "NODE_FROM_ID");
        public final static Property NodeToId = new Property(4, long.class, "nodeToId", false, "NODE_TO_ID");
    };

    private DaoSession daoSession;

    private Query<Link> node_OutsQuery;

    public LinkDao(DaoConfig config) {
        super(config);
    }
    
    public LinkDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'LINK' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'LENGTH' REAL," + // 1: length
                "'SPEED' REAL," + // 2: speed
                "'NODE_FROM_ID' INTEGER NOT NULL ," + // 3: nodeFromId
                "'NODE_TO_ID' INTEGER NOT NULL );"); // 4: nodeToId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'LINK'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Link entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Double length = entity.getLength();
        if (length != null) {
            stmt.bindDouble(2, length);
        }
 
        Double speed = entity.getSpeed();
        if (speed != null) {
            stmt.bindDouble(3, speed);
        }
        stmt.bindLong(4, entity.getNodeFromId());
        stmt.bindLong(5, entity.getNodeToId());
    }

    @Override
    protected void attachEntity(Link entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public Link readEntity(Cursor cursor, int offset) {
        Link entity = new Link( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getDouble(offset + 1), // length
            cursor.isNull(offset + 2) ? null : cursor.getDouble(offset + 2), // speed
            cursor.getLong(offset + 3), // nodeFromId
            cursor.getLong(offset + 4) // nodeToId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Link entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setLength(cursor.isNull(offset + 1) ? null : cursor.getDouble(offset + 1));
        entity.setSpeed(cursor.isNull(offset + 2) ? null : cursor.getDouble(offset + 2));
        entity.setNodeFromId(cursor.getLong(offset + 3));
        entity.setNodeToId(cursor.getLong(offset + 4));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Link entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(Link entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "outs" to-many relationship of Node. */
    public List<Link> _queryNode_Outs(long nodeFromId) {
        synchronized (this) {
            if (node_OutsQuery == null) {
                QueryBuilder<Link> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.NodeFromId.eq(null));
                node_OutsQuery = queryBuilder.build();
            }
        }
        Query<Link> query = node_OutsQuery.forCurrentThread();
        query.setParameter(0, nodeFromId);
        return query.list();
    }

    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getNodeDao().getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T1", daoSession.getNodeDao().getAllColumns());
            builder.append(" FROM LINK T");
            builder.append(" LEFT JOIN NODE T0 ON T.'NODE_FROM_ID'=T0.'_id'");
            builder.append(" LEFT JOIN NODE T1 ON T.'NODE_TO_ID'=T1.'_id'");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }
    
    protected Link loadCurrentDeep(Cursor cursor, boolean lock) {
        Link entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        Node nodeFrom = loadCurrentOther(daoSession.getNodeDao(), cursor, offset);
         if(nodeFrom != null) {
            entity.setNodeFrom(nodeFrom);
        }
        offset += daoSession.getNodeDao().getAllColumns().length;

        Node nodeTo = loadCurrentOther(daoSession.getNodeDao(), cursor, offset);
         if(nodeTo != null) {
            entity.setNodeTo(nodeTo);
        }

        return entity;    
    }

    public Link loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();
        
        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);
        
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }
    
    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<Link> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<Link> list = new ArrayList<Link>(count);
        
        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }
    
    protected List<Link> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }
    

    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<Link> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }
 
}
