package com.cc.infosur.greendao;

import java.util.List;
import java.util.ArrayList;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/**
 * DAO for table EXCURSION.
 */
public class ExcursionDao extends AbstractDao<Excursion, Long> {

    public static final String TABLENAME = "EXCURSION";

    /**
     * Properties of entity Excursion.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property ExcursionOrder = new Property(1, Integer.class, "excursionOrder", false, "EXCURSION_ORDER");
        public final static Property Name = new Property(2, String.class, "name", false, "NAME");
        public final static Property Region = new Property(3, String.class, "region", false, "REGION");
        public final static Property Latitude = new Property(4, Double.class, "latitude", false, "LATITUDE");
        public final static Property Longitude = new Property(5, Double.class, "longitude", false, "LONGITUDE");
        public final static Property Icon = new Property(6, byte[].class, "icon", false, "ICON");
        public final static Property Description = new Property(7, String.class, "description", false, "DESCRIPTION");
        public final static Property StepId = new Property(8, long.class, "stepId", false, "STEP_ID");
    };

    private DaoSession daoSession;

    private Query<Excursion> step_ExcursionsQuery;

    public ExcursionDao(DaoConfig config) {
        super(config);
    }

    public ExcursionDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'EXCURSION' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'EXCURSION_ORDER' INTEGER," + // 1: excursionOrder
                "'NAME' TEXT," + // 2: name
                "'REGION' TEXT," + // 3: region
                "'LATITUDE' REAL," + // 4: latitude
                "'LONGITUDE' REAL," + // 5: longitude
                "'ICON' BLOB," + // 6: icon
                "'DESCRIPTION' TEXT," + // 7:description
                "'STEP_ID' INTEGER NOT NULL );"); // 8: stepId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'EXCURSION'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Excursion entity) {
        stmt.clearBindings();

        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }

        Integer excursionOrder = entity.getExcursionOrder();
        if (excursionOrder != null) {
            stmt.bindLong(2, excursionOrder);
        }

        String name = entity.getName();
        if (name != null) {
            stmt.bindString(3, name);
        }

        String region = entity.getRegion();
        if (region != null) {
            stmt.bindString(4, region);
        }

        Double latitude = entity.getLatitude();
        if (latitude != null) {
            stmt.bindDouble(5, latitude);
        }

        Double longitude = entity.getLongitude();
        if (longitude != null) {
            stmt.bindDouble(6, longitude);
        }
        byte[] icon = entity.getIcon();
        if (icon != null) {
            stmt.bindBlob(7, icon);
        }
        String description = entity.getDescription();
        if (description != null) {
            stmt.bindString(8, description);
        }
        stmt.bindLong(9, entity.getStepId());
    }

    @Override
    protected void attachEntity(Excursion entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }

    /** @inheritdoc */
    @Override
    public Excursion readEntity(Cursor cursor, int offset) {
        Excursion entity = new Excursion( //
                cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
                cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1), // excursionOrder
                cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // name
                cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), // region
                cursor.isNull(offset + 4) ? null : cursor.getDouble(offset + 4), // latitude
                cursor.isNull(offset + 5) ? null : cursor.getDouble(offset + 5), // longitude
                cursor.isNull(offset + 6) ? null : cursor.getBlob(offset + 6), // byte
                cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // description
                cursor.getLong(offset + 8) // stepId
        );
        return entity;
    }

    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Excursion entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setExcursionOrder(cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1));
        entity.setName(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setRegion(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setLatitude(cursor.isNull(offset + 4) ? null : cursor.getDouble(offset + 4));
        entity.setLongitude(cursor.isNull(offset + 5) ? null : cursor.getDouble(offset + 5));
        entity.setIcon(cursor.isNull(offset + 6) ? null : cursor.getBlob(offset + 6));
        entity.setDescription(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setStepId(cursor.getLong(offset + 8));
    }

    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Excursion entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }

    /** @inheritdoc */
    @Override
    public Long getKey(Excursion entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override
    protected boolean isEntityUpdateable() {
        return true;
    }

    /** Internal query to resolve the "excursions" to-many relationship of Step. */
    public List<Excursion> _queryStep_Excursions(long stepId) {
        synchronized (this) {
            if (step_ExcursionsQuery == null) {
                QueryBuilder<Excursion> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.StepId.eq(null));
                queryBuilder.orderRaw("EXCURSION_ORDER ASC");
                step_ExcursionsQuery = queryBuilder.build();
            }
        }
        Query<Excursion> query = step_ExcursionsQuery.forCurrentThread();
        query.setParameter(0, stepId);
        return query.list();
    }

    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getStepDao().getAllColumns());
            builder.append(" FROM EXCURSION T");
            builder.append(" LEFT JOIN STEP T0 ON T.'STEP_ID'=T0.'_id'");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }

    protected Excursion loadCurrentDeep(Cursor cursor, boolean lock) {
        Excursion entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        Step step = loadCurrentOther(daoSession.getStepDao(), cursor, offset);
        if(step != null) {
            entity.setStep(step);
        }

        return entity;
    }

    public Excursion loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();

        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);

        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }

    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<Excursion> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<Excursion> list = new ArrayList<Excursion>(count);

        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }

    protected List<Excursion> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }


    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<Excursion> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }

}
