package com.cc.infosur.greendao;

import java.util.List;
import java.util.ArrayList;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table DETAIL.
*/
public class DetailDao extends AbstractDao<Detail, Long> {

    public static final String TABLENAME = "DETAIL";

    /**
     * Properties of entity Detail.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Fulldescr = new Property(1, String.class, "fulldescr", false, "FULLDESCR");
        public final static Property Picture = new Property(2, byte[].class, "picture", false, "PICTURE");
        public final static Property DetailOrder = new Property(3, Integer.class, "detailOrder", false, "DETAIL_ORDER");
        public final static Property ServiceId = new Property(4, long.class, "serviceId", false, "SERVICE_ID");
        public final static Property StepId = new Property(5, long.class, "stepId", false, "STEP_ID");
        public final static Property FloraId = new Property(6, long.class, "floraId", false, "FLORA_ID");
        public final static Property FaunaId = new Property(7, long.class, "faunaId", false, "FAUNA_ID");
        public final static Property HeritageId = new Property(8, long.class, "heritageId", false, "HERITAGE_ID");
    };

    private DaoSession daoSession;

    private Query<Detail> service_DetailsQuery;
    private Query<Detail> step_DetailsQuery;
    private Query<Detail> flora_DetailsQuery;
    private Query<Detail> fauna_DetailsQuery;
    private Query<Detail> heritage_DetailsQuery;

    public DetailDao(DaoConfig config) {
        super(config);
    }
    
    public DetailDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'DETAIL' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'FULLDESCR' TEXT," + // 1: fulldescr
                "'PICTURE' BLOB," + // 2: picture
                "'DETAIL_ORDER' INTEGER," + // 3: detailOrder
                "'SERVICE_ID' INTEGER NOT NULL ," + // 4: serviceId
                "'STEP_ID' INTEGER NOT NULL ," + // 5: stepId
                "'FLORA_ID' INTEGER NOT NULL ," + // 6: floraId
                "'FAUNA_ID' INTEGER NOT NULL ," + // 7: faunaId
                "'HERITAGE_ID' INTEGER NOT NULL );"); // 8: heritageId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'DETAIL'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Detail entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        String fulldescr = entity.getFulldescr();
        if (fulldescr != null) {
            stmt.bindString(2, fulldescr);
        }
 
        byte[] picture = entity.getPicture();
        if (picture != null) {
            stmt.bindBlob(3, picture);
        }
 
        Integer detailOrder = entity.getDetailOrder();
        if (detailOrder != null) {
            stmt.bindLong(4, detailOrder);
        }
        stmt.bindLong(5, entity.getServiceId());
        stmt.bindLong(6, entity.getStepId());
        stmt.bindLong(7, entity.getFloraId());
        stmt.bindLong(8, entity.getFaunaId());
        stmt.bindLong(9, entity.getHeritageId());
    }

    @Override
    protected void attachEntity(Detail entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public Detail readEntity(Cursor cursor, int offset) {
        Detail entity = new Detail( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), // fulldescr
            cursor.isNull(offset + 2) ? null : cursor.getBlob(offset + 2), // picture
            cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3), // detailOrder
            cursor.getLong(offset + 4), // serviceId
            cursor.getLong(offset + 5), // stepId
            cursor.getLong(offset + 6), // floraId
            cursor.getLong(offset + 7), // faunaId
            cursor.getLong(offset + 8) // heritageId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Detail entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setFulldescr(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setPicture(cursor.isNull(offset + 2) ? null : cursor.getBlob(offset + 2));
        entity.setDetailOrder(cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3));
        entity.setServiceId(cursor.getLong(offset + 4));
        entity.setStepId(cursor.getLong(offset + 5));
        entity.setFloraId(cursor.getLong(offset + 6));
        entity.setFaunaId(cursor.getLong(offset + 7));
        entity.setHeritageId(cursor.getLong(offset + 8));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Detail entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(Detail entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "details" to-many relationship of Service. */
    public List<Detail> _queryService_Details(long serviceId) {
        synchronized (this) {
            if (service_DetailsQuery == null) {
                QueryBuilder<Detail> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.ServiceId.eq(null));
                queryBuilder.orderRaw("DETAIL_ORDER ASC");
                service_DetailsQuery = queryBuilder.build();
            }
        }
        Query<Detail> query = service_DetailsQuery.forCurrentThread();
        query.setParameter(0, serviceId);
        return query.list();
    }

    /** Internal query to resolve the "details" to-many relationship of Step. */
    public List<Detail> _queryStep_Details(long stepId) {
        synchronized (this) {
            if (step_DetailsQuery == null) {
                QueryBuilder<Detail> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.StepId.eq(null));
                queryBuilder.orderRaw("DETAIL_ORDER ASC");
                step_DetailsQuery = queryBuilder.build();
            }
        }
        Query<Detail> query = step_DetailsQuery.forCurrentThread();
        query.setParameter(0, stepId);
        return query.list();
    }

    /** Internal query to resolve the "details" to-many relationship of Flora. */
    public List<Detail> _queryFlora_Details(long floraId) {
        synchronized (this) {
            if (flora_DetailsQuery == null) {
                QueryBuilder<Detail> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.FloraId.eq(null));
                queryBuilder.orderRaw("DETAIL_ORDER ASC");
                flora_DetailsQuery = queryBuilder.build();
            }
        }
        Query<Detail> query = flora_DetailsQuery.forCurrentThread();
        query.setParameter(0, floraId);
        return query.list();
    }

    /** Internal query to resolve the "details" to-many relationship of Fauna. */
    public List<Detail> _queryFauna_Details(long faunaId) {
        synchronized (this) {
            if (fauna_DetailsQuery == null) {
                QueryBuilder<Detail> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.FaunaId.eq(null));
                queryBuilder.orderRaw("DETAIL_ORDER ASC");
                fauna_DetailsQuery = queryBuilder.build();
            }
        }
        Query<Detail> query = fauna_DetailsQuery.forCurrentThread();
        query.setParameter(0, faunaId);
        return query.list();
    }

    /** Internal query to resolve the "details" to-many relationship of Heritage. */
    public List<Detail> _queryHeritage_Details(long heritageId) {
        synchronized (this) {
            if (heritage_DetailsQuery == null) {
                QueryBuilder<Detail> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.HeritageId.eq(null));
                queryBuilder.orderRaw("DETAIL_ORDER ASC");
                heritage_DetailsQuery = queryBuilder.build();
            }
        }
        Query<Detail> query = heritage_DetailsQuery.forCurrentThread();
        query.setParameter(0, heritageId);
        return query.list();
    }

    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getServiceDao().getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T1", daoSession.getStepDao().getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T2", daoSession.getFloraDao().getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T3", daoSession.getFaunaDao().getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T4", daoSession.getHeritageDao().getAllColumns());
            builder.append(" FROM DETAIL T");
            builder.append(" LEFT JOIN SERVICE T0 ON T.'SERVICE_ID'=T0.'_id'");
            builder.append(" LEFT JOIN STEP T1 ON T.'STEP_ID'=T1.'_id'");
            builder.append(" LEFT JOIN FLORA T2 ON T.'FLORA_ID'=T2.'_id'");
            builder.append(" LEFT JOIN FAUNA T3 ON T.'FAUNA_ID'=T3.'_id'");
            builder.append(" LEFT JOIN HERITAGE T4 ON T.'HERITAGE_ID'=T4.'_id'");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }
    
    protected Detail loadCurrentDeep(Cursor cursor, boolean lock) {
        Detail entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        Service service = loadCurrentOther(daoSession.getServiceDao(), cursor, offset);
         if(service != null) {
            entity.setService(service);
        }
        offset += daoSession.getServiceDao().getAllColumns().length;

        Step step = loadCurrentOther(daoSession.getStepDao(), cursor, offset);
         if(step != null) {
            entity.setStep(step);
        }
        offset += daoSession.getStepDao().getAllColumns().length;

        Flora flora = loadCurrentOther(daoSession.getFloraDao(), cursor, offset);
         if(flora != null) {
            entity.setFlora(flora);
        }
        offset += daoSession.getFloraDao().getAllColumns().length;

        Fauna fauna = loadCurrentOther(daoSession.getFaunaDao(), cursor, offset);
         if(fauna != null) {
            entity.setFauna(fauna);
        }
        offset += daoSession.getFaunaDao().getAllColumns().length;

        Heritage heritage = loadCurrentOther(daoSession.getHeritageDao(), cursor, offset);
         if(heritage != null) {
            entity.setHeritage(heritage);
        }

        return entity;    
    }

    public Detail loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();
        
        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);
        
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }
    
    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<Detail> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<Detail> list = new ArrayList<Detail>(count);
        
        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }
    
    protected List<Detail> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }
    

    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<Detail> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }
 
}
