package com.cc.infosur.greendao;

import java.util.List;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table DB_POLYGON.
*/
public class DbPolygonDao extends AbstractDao<DbPolygon, Long> {

    public static final String TABLENAME = "DB_POLYGON";

    /**
     * Properties of entity DbPolygon.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property FloraId = new Property(1, long.class, "floraId", false, "FLORA_ID");
        public final static Property FaunaId = new Property(2, long.class, "faunaId", false, "FAUNA_ID");
        public final static Property HeritageId = new Property(3, long.class, "heritageId", false, "HERITAGE_ID");
        public final static Property ParkInfoRestrictedId = new Property(4, long.class, "parkInfoRestrictedId", false, "PARK_INFO_RESTRICTED_ID");
        public final static Property ParkInfoAccommodationId = new Property(5, long.class, "parkInfoAccommodationId", false, "PARK_INFO_ACCOMMODATION_ID");
    };

    private DaoSession daoSession;

    private Query<DbPolygon> flora_PolygonsQuery;
    private Query<DbPolygon> fauna_PolygonsQuery;
    private Query<DbPolygon> heritage_PolygonsQuery;
    private Query<DbPolygon> parkInfo_RestrictedAreasQuery;
    private Query<DbPolygon> parkInfo_AccommodationAreasQuery;

    public DbPolygonDao(DaoConfig config) {
        super(config);
    }
    
    public DbPolygonDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'DB_POLYGON' (" + //
                "'_id' INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "'FLORA_ID' INTEGER NOT NULL ," + // 1: floraId
                "'FAUNA_ID' INTEGER NOT NULL ," + // 2: faunaId
                "'HERITAGE_ID' INTEGER NOT NULL ," + // 3: heritageId
                "'PARK_INFO_RESTRICTED_ID' INTEGER NOT NULL ," + // 4: parkInfoRestrictedId
                "'PARK_INFO_ACCOMMODATION_ID' INTEGER NOT NULL );"); // 5: parkInfoAccommodationId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'DB_POLYGON'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, DbPolygon entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getFloraId());
        stmt.bindLong(3, entity.getFaunaId());
        stmt.bindLong(4, entity.getHeritageId());
        stmt.bindLong(5, entity.getParkInfoRestrictedId());
        stmt.bindLong(6, entity.getParkInfoAccommodationId());
    }

    @Override
    protected void attachEntity(DbPolygon entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public DbPolygon readEntity(Cursor cursor, int offset) {
        DbPolygon entity = new DbPolygon( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getLong(offset + 1), // floraId
            cursor.getLong(offset + 2), // faunaId
            cursor.getLong(offset + 3), // heritageId
            cursor.getLong(offset + 4), // parkInfoRestrictedId
            cursor.getLong(offset + 5) // parkInfoAccommodationId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, DbPolygon entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setFloraId(cursor.getLong(offset + 1));
        entity.setFaunaId(cursor.getLong(offset + 2));
        entity.setHeritageId(cursor.getLong(offset + 3));
        entity.setParkInfoRestrictedId(cursor.getLong(offset + 4));
        entity.setParkInfoAccommodationId(cursor.getLong(offset + 5));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(DbPolygon entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(DbPolygon entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "polygons" to-many relationship of Flora. */
    public List<DbPolygon> _queryFlora_Polygons(long floraId) {
        synchronized (this) {
            if (flora_PolygonsQuery == null) {
                QueryBuilder<DbPolygon> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.FloraId.eq(null));
                flora_PolygonsQuery = queryBuilder.build();
            }
        }
        Query<DbPolygon> query = flora_PolygonsQuery.forCurrentThread();
        query.setParameter(0, floraId);
        return query.list();
    }

    /** Internal query to resolve the "polygons" to-many relationship of Fauna. */
    public List<DbPolygon> _queryFauna_Polygons(long faunaId) {
        synchronized (this) {
            if (fauna_PolygonsQuery == null) {
                QueryBuilder<DbPolygon> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.FaunaId.eq(null));
                fauna_PolygonsQuery = queryBuilder.build();
            }
        }
        Query<DbPolygon> query = fauna_PolygonsQuery.forCurrentThread();
        query.setParameter(0, faunaId);
        return query.list();
    }

    /** Internal query to resolve the "polygons" to-many relationship of Heritage. */
    public List<DbPolygon> _queryHeritage_Polygons(long heritageId) {
        synchronized (this) {
            if (heritage_PolygonsQuery == null) {
                QueryBuilder<DbPolygon> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.HeritageId.eq(null));
                heritage_PolygonsQuery = queryBuilder.build();
            }
        }
        Query<DbPolygon> query = heritage_PolygonsQuery.forCurrentThread();
        query.setParameter(0, heritageId);
        return query.list();
    }

    /** Internal query to resolve the "restrictedAreas" to-many relationship of ParkInfo. */
    public List<DbPolygon> _queryParkInfo_RestrictedAreas(long parkInfoRestrictedId) {
        synchronized (this) {
            if (parkInfo_RestrictedAreasQuery == null) {
                QueryBuilder<DbPolygon> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.ParkInfoRestrictedId.eq(null));
                parkInfo_RestrictedAreasQuery = queryBuilder.build();
            }
        }
        Query<DbPolygon> query = parkInfo_RestrictedAreasQuery.forCurrentThread();
        query.setParameter(0, parkInfoRestrictedId);
        return query.list();
    }

    /** Internal query to resolve the "accommodationAreas" to-many relationship of ParkInfo. */
    public List<DbPolygon> _queryParkInfo_AccommodationAreas(long parkInfoAccommodationId) {
        synchronized (this) {
            if (parkInfo_AccommodationAreasQuery == null) {
                QueryBuilder<DbPolygon> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.ParkInfoAccommodationId.eq(null));
                parkInfo_AccommodationAreasQuery = queryBuilder.build();
            }
        }
        Query<DbPolygon> query = parkInfo_AccommodationAreasQuery.forCurrentThread();
        query.setParameter(0, parkInfoAccommodationId);
        return query.list();
    }

}
