package com.cc.infosur.greendao;

import java.util.List;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table DB_POINT.
*/
public class DbPointDao extends AbstractDao<DbPoint, Long> {

    public static final String TABLENAME = "DB_POINT";

    /**
     * Properties of entity DbPoint.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Latitude = new Property(1, Double.class, "latitude", false, "LATITUDE");
        public final static Property Longitude = new Property(2, Double.class, "longitude", false, "LONGITUDE");
        public final static Property PolygonId = new Property(3, long.class, "polygonId", false, "POLYGON_ID");
        public final static Property LineId = new Property(4, long.class, "lineId", false, "LINE_ID");
        public final static Property FloraId = new Property(5, long.class, "floraId", false, "FLORA_ID");
    };

    private Query<DbPoint> dbPolygon_PointsQuery;
    private Query<DbPoint> dbLine_PointsQuery;
    private Query<DbPoint> flora_PointsQuery;

    public DbPointDao(DaoConfig config) {
        super(config);
    }
    
    public DbPointDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'DB_POINT' (" + //
                "'_id' INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "'LATITUDE' REAL," + // 1: latitude
                "'LONGITUDE' REAL," + // 2: longitude
                "'POLYGON_ID' INTEGER NOT NULL ," + // 3: polygonId
                "'LINE_ID' INTEGER NOT NULL ," + // 4: lineId
                "'FLORA_ID' INTEGER NOT NULL );"); // 5: floraId
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'DB_POINT'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, DbPoint entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Double latitude = entity.getLatitude();
        if (latitude != null) {
            stmt.bindDouble(2, latitude);
        }
 
        Double longitude = entity.getLongitude();
        if (longitude != null) {
            stmt.bindDouble(3, longitude);
        }
        stmt.bindLong(4, entity.getPolygonId());
        stmt.bindLong(5, entity.getLineId());
        stmt.bindLong(6, entity.getFloraId());
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public DbPoint readEntity(Cursor cursor, int offset) {
        DbPoint entity = new DbPoint( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getDouble(offset + 1), // latitude
            cursor.isNull(offset + 2) ? null : cursor.getDouble(offset + 2), // longitude
            cursor.getLong(offset + 3), // polygonId
            cursor.getLong(offset + 4), // lineId
            cursor.getLong(offset + 5) // floraId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, DbPoint entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setLatitude(cursor.isNull(offset + 1) ? null : cursor.getDouble(offset + 1));
        entity.setLongitude(cursor.isNull(offset + 2) ? null : cursor.getDouble(offset + 2));
        entity.setPolygonId(cursor.getLong(offset + 3));
        entity.setLineId(cursor.getLong(offset + 4));
        entity.setFloraId(cursor.getLong(offset + 5));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(DbPoint entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(DbPoint entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "points" to-many relationship of DbPolygon. */
    public List<DbPoint> _queryDbPolygon_Points(long polygonId) {
        synchronized (this) {
            if (dbPolygon_PointsQuery == null) {
                QueryBuilder<DbPoint> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.PolygonId.eq(null));
                dbPolygon_PointsQuery = queryBuilder.build();
            }
        }
        Query<DbPoint> query = dbPolygon_PointsQuery.forCurrentThread();
        query.setParameter(0, polygonId);
        return query.list();
    }

    /** Internal query to resolve the "points" to-many relationship of DbLine. */
    public List<DbPoint> _queryDbLine_Points(long lineId) {
        synchronized (this) {
            if (dbLine_PointsQuery == null) {
                QueryBuilder<DbPoint> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.LineId.eq(null));
                dbLine_PointsQuery = queryBuilder.build();
            }
        }
        Query<DbPoint> query = dbLine_PointsQuery.forCurrentThread();
        query.setParameter(0, lineId);
        return query.list();
    }

    /** Internal query to resolve the "points" to-many relationship of Flora. */
    public List<DbPoint> _queryFlora_Points(long floraId) {
        synchronized (this) {
            if (flora_PointsQuery == null) {
                QueryBuilder<DbPoint> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.FloraId.eq(null));
                flora_PointsQuery = queryBuilder.build();
            }
        }
        Query<DbPoint> query = flora_PointsQuery.forCurrentThread();
        query.setParameter(0, floraId);
        return query.list();
    }

}
