package com.cc.infosur.greendao;

import java.util.List;
import java.util.ArrayList;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.SqlUtils;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.query.Query;
import de.greenrobot.dao.query.QueryBuilder;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table DAY.
*/
public class DayDao extends AbstractDao<Day, Long> {

    public static final String TABLENAME = "DAY";

    /**
     * Properties of entity Day.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property Day = new Property(1, java.util.Date.class, "day", false, "DAY");
        public final static Property TripId = new Property(2, long.class, "tripId", false, "TRIP_ID");
        public final static Property Park = new Property(3, Integer.class, "park", false, "PARK");
    };

    private DaoSession daoSession;

    private Query<Day> trip_DaysQuery;

    public DayDao(DaoConfig config) {
        super(config);
    }
    
    public DayDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'DAY' (" + //
                "'_id' INTEGER PRIMARY KEY ," + // 0: id
                "'DAY' INTEGER," + // 1: day
                "'TRIP_ID' INTEGER NOT NULL ," + // 2: tripId
                "'PARK' INTEGER);"); // 3: park
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'DAY'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Day entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        java.util.Date day = entity.getDay();
        if (day != null) {
            stmt.bindLong(2, day.getTime());
        }
        stmt.bindLong(3, entity.getTripId());
 
        Integer park = entity.getPark();
        if (park != null) {
            stmt.bindLong(4, park);
        }
    }

    @Override
    protected void attachEntity(Day entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public Day readEntity(Cursor cursor, int offset) {
        Day entity = new Day( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : new java.util.Date(cursor.getLong(offset + 1)), // day
            cursor.getLong(offset + 2), // tripId
            cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3) // park
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Day entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setDay(cursor.isNull(offset + 1) ? null : new java.util.Date(cursor.getLong(offset + 1)));
        entity.setTripId(cursor.getLong(offset + 2));
        entity.setPark(cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Day entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(Day entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "days" to-many relationship of Trip. */
    public List<Day> _queryTrip_Days(long tripId) {
        synchronized (this) {
            if (trip_DaysQuery == null) {
                QueryBuilder<Day> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.TripId.eq(null));
                queryBuilder.orderRaw("DAY ASC");
                trip_DaysQuery = queryBuilder.build();
            }
        }
        Query<Day> query = trip_DaysQuery.forCurrentThread();
        query.setParameter(0, tripId);
        return query.list();
    }

    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getTripDao().getAllColumns());
            builder.append(" FROM DAY T");
            builder.append(" LEFT JOIN TRIP T0 ON T.'TRIP_ID'=T0.'_id'");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }
    
    protected Day loadCurrentDeep(Cursor cursor, boolean lock) {
        Day entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        Trip trip = loadCurrentOther(daoSession.getTripDao(), cursor, offset);
         if(trip != null) {
            entity.setTrip(trip);
        }

        return entity;    
    }

    public Day loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();
        
        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);
        
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }
    
    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<Day> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<Day> list = new ArrayList<Day>(count);
        
        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }
    
    protected List<Day> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }
    

    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<Day> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }
 
}
