package com.cc.infosur.greendao;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import de.greenrobot.dao.AbstractDaoMaster;
import de.greenrobot.dao.identityscope.IdentityScopeType;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * Master of DAO (schema version 1): knows all DAOs.
*/
public class DaoMaster extends AbstractDaoMaster {
    public static final int SCHEMA_VERSION = 1;

    /** Creates underlying database table using DAOs. */
    public static void createAllTables(SQLiteDatabase db, boolean ifNotExists) {
        TravellerInfoDao.createTable(db, ifNotExists);
        ParkInfoDao.createTable(db, ifNotExists);
        MonthOpeningTimeDao.createTable(db, ifNotExists);
        TripInfoDao.createTable(db, ifNotExists);
        TripDao.createTable(db, ifNotExists);
        UserPicturesDao.createTable(db, ifNotExists);
        DayDao.createTable(db, ifNotExists);
        StepDao.createTable(db, ifNotExists);
        ExcursionDao.createTable(db, ifNotExists);
        ServiceDao.createTable(db, ifNotExists);
        DetailDao.createTable(db, ifNotExists);
        DayServiceRelDao.createTable(db, ifNotExists);
        QuestionaryDao.createTable(db, ifNotExists);
        QuestionDao.createTable(db, ifNotExists);
        ObservationDao.createTable(db, ifNotExists);
        ChatDao.createTable(db, ifNotExists);
        DangerousDao.createTable(db, ifNotExists);
        AlertDao.createTable(db, ifNotExists);
        FloraDao.createTable(db, ifNotExists);
        FaunaDao.createTable(db, ifNotExists);
        HeritageDao.createTable(db, ifNotExists);
        DbPolygonDao.createTable(db, ifNotExists);
        DbLineDao.createTable(db, ifNotExists);
        DbPointDao.createTable(db, ifNotExists);
        NodeDao.createTable(db, ifNotExists);
        LinkDao.createTable(db, ifNotExists);
        RequestDao.createTable(db, ifNotExists);
    }
    
    /** Drops underlying database table using DAOs. */
    public static void dropAllTables(SQLiteDatabase db, boolean ifExists) {
        TravellerInfoDao.dropTable(db, ifExists);
        ParkInfoDao.dropTable(db, ifExists);
        MonthOpeningTimeDao.dropTable(db, ifExists);
        TripInfoDao.dropTable(db, ifExists);
        TripDao.dropTable(db, ifExists);
        UserPicturesDao.dropTable(db, ifExists);
        DayDao.dropTable(db, ifExists);
        StepDao.dropTable(db, ifExists);
        ExcursionDao.dropTable(db, ifExists);
        ServiceDao.dropTable(db, ifExists);
        DetailDao.dropTable(db, ifExists);
        DayServiceRelDao.dropTable(db, ifExists);
        QuestionaryDao.dropTable(db, ifExists);
        QuestionDao.dropTable(db, ifExists);
        ObservationDao.dropTable(db, ifExists);
        ChatDao.dropTable(db, ifExists);
        DangerousDao.dropTable(db, ifExists);
        AlertDao.dropTable(db, ifExists);
        FloraDao.dropTable(db, ifExists);
        FaunaDao.dropTable(db, ifExists);
        HeritageDao.dropTable(db, ifExists);
        DbPolygonDao.dropTable(db, ifExists);
        DbLineDao.dropTable(db, ifExists);
        DbPointDao.dropTable(db, ifExists);
        NodeDao.dropTable(db, ifExists);
        LinkDao.dropTable(db, ifExists);
        RequestDao.dropTable(db, ifExists);
    }
    
    public static abstract class OpenHelper extends SQLiteOpenHelper {

        public OpenHelper(Context context, String name, CursorFactory factory) {
            super(context, name, factory, SCHEMA_VERSION);
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            Log.i("greenDAO", "Creating tables for schema version " + SCHEMA_VERSION);
            createAllTables(db, false);
        }
    }
    
    /** WARNING: Drops all table on Upgrade! Use only during development. */
    public static class DevOpenHelper extends OpenHelper {
        public DevOpenHelper(Context context, String name, CursorFactory factory) {
            super(context, name, factory);
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.i("greenDAO", "Upgrading schema from version " + oldVersion + " to " + newVersion + " by dropping all tables");
            dropAllTables(db, true);
            onCreate(db);
        }
    }

    public DaoMaster(SQLiteDatabase db) {
        super(db, SCHEMA_VERSION);
        registerDaoClass(TravellerInfoDao.class);
        registerDaoClass(ParkInfoDao.class);
        registerDaoClass(MonthOpeningTimeDao.class);
        registerDaoClass(TripInfoDao.class);
        registerDaoClass(TripDao.class);
        registerDaoClass(UserPicturesDao.class);
        registerDaoClass(DayDao.class);
        registerDaoClass(StepDao.class);
        registerDaoClass(ExcursionDao.class);
        registerDaoClass(ServiceDao.class);
        registerDaoClass(DetailDao.class);
        registerDaoClass(DayServiceRelDao.class);
        registerDaoClass(QuestionaryDao.class);
        registerDaoClass(QuestionDao.class);
        registerDaoClass(ObservationDao.class);
        registerDaoClass(ChatDao.class);
        registerDaoClass(DangerousDao.class);
        registerDaoClass(AlertDao.class);
        registerDaoClass(FloraDao.class);
        registerDaoClass(FaunaDao.class);
        registerDaoClass(HeritageDao.class);
        registerDaoClass(DbPolygonDao.class);
        registerDaoClass(DbLineDao.class);
        registerDaoClass(DbPointDao.class);
        registerDaoClass(NodeDao.class);
        registerDaoClass(LinkDao.class);
        registerDaoClass(RequestDao.class);
    }
    
    public DaoSession newSession() {
        return new DaoSession(db, IdentityScopeType.Session, daoConfigMap);
    }
    
    public DaoSession newSession(IdentityScopeType type) {
        return new DaoSession(db, type, daoConfigMap);
    }
    
}
