package com.cc.infosur.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;


// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table CHAT.
*/
public class ChatDao extends AbstractDao<Chat, Long> {

    public static final String TABLENAME = "CHAT";

    /**
     * Properties of entity Chat.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property MessageId = new Property(1, Long.class, "messageId", false, "MESSAGE_ID");
        public final static Property Text = new Property(2, String.class, "text", false, "TEXT");
        public final static Property Source = new Property(3, Boolean.class, "source", false, "SOURCE");
        public final static Property Date = new Property(4, java.util.Date.class, "date", false, "DATE");
        public final static Property Read_ack = new Property(5, Boolean.class, "read_ack", false, "READ_ACK");
        public final static Property Sent = new Property(6, Boolean.class, "sent", false, "SENT");
        public final static Property Status = new Property(7, String.class, "status", false, "STATUS");
        public final static Property Rock7Id = new Property(8, Long.class, "rock7Id", false, "ROCK7_ID");
        public final static Property Lat = new Property(9, String.class, "lat", false, "LAT");
        public final static Property Lon = new Property(10, String.class, "lon", false, "LON");
        public final static Property TosendOrder = new Property(11, Long.class, "tosendOrder", false, "TOSEND_ORDER");
    };


    public ChatDao(DaoConfig config) {
        super(config);
    }
    
    public ChatDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "'CHAT' (" + //
                "'_id' INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "'MESSAGE_ID' INTEGER," + // 1: messageId
                "'TEXT' TEXT," + // 2: text
                "'SOURCE' INTEGER," + // 3: source
                "'DATE' INTEGER," + // 4: date
                "'READ_ACK' INTEGER," + // 5: read_ack
                "'SENT' INTEGER," + // 6: sent
                "'STATUS' TEXT," + // 7: status
                "'ROCK7_ID' INTEGER," + // 8: rock7Id
                "'LAT' TEXT," + // 9: lat
                "'LON' TEXT," + // 10: lon
                "'TOSEND_ORDER' INTEGER);"); // 11: tosendOrder
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "'CHAT'";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Chat entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long messageId = entity.getMessageId();
        if (messageId != null) {
            stmt.bindLong(2, messageId);
        }
 
        String text = entity.getText();
        if (text != null) {
            stmt.bindString(3, text);
        }
 
        Boolean source = entity.getSource();
        if (source != null) {
            stmt.bindLong(4, source ? 1l: 0l);
        }
 
        java.util.Date date = entity.getDate();
        if (date != null) {
            stmt.bindLong(5, date.getTime());
        }
 
        Boolean read_ack = entity.getRead_ack();
        if (read_ack != null) {
            stmt.bindLong(6, read_ack ? 1l: 0l);
        }
 
        Boolean sent = entity.getSent();
        if (sent != null) {
            stmt.bindLong(7, sent ? 1l: 0l);
        }
 
        String status = entity.getStatus();
        if (status != null) {
            stmt.bindString(8, status);
        }
 
        Long rock7Id = entity.getRock7Id();
        if (rock7Id != null) {
            stmt.bindLong(9, rock7Id);
        }
 
        String lat = entity.getLat();
        if (lat != null) {
            stmt.bindString(10, lat);
        }
 
        String lon = entity.getLon();
        if (lon != null) {
            stmt.bindString(11, lon);
        }
 
        Long tosendOrder = entity.getTosendOrder();
        if (tosendOrder != null) {
            stmt.bindLong(12, tosendOrder);
        }
    }

    /** @inheritdoc */
    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    /** @inheritdoc */
    @Override
    public Chat readEntity(Cursor cursor, int offset) {
        Chat entity = new Chat( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // messageId
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // text
            cursor.isNull(offset + 3) ? null : cursor.getShort(offset + 3) != 0, // source
            cursor.isNull(offset + 4) ? null : new java.util.Date(cursor.getLong(offset + 4)), // date
            cursor.isNull(offset + 5) ? null : cursor.getShort(offset + 5) != 0, // read_ack
            cursor.isNull(offset + 6) ? null : cursor.getShort(offset + 6) != 0, // sent
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // status
            cursor.isNull(offset + 8) ? null : cursor.getLong(offset + 8), // rock7Id
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9), // lat
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // lon
            cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11) // tosendOrder
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Chat entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setMessageId(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setText(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setSource(cursor.isNull(offset + 3) ? null : cursor.getShort(offset + 3) != 0);
        entity.setDate(cursor.isNull(offset + 4) ? null : new java.util.Date(cursor.getLong(offset + 4)));
        entity.setRead_ack(cursor.isNull(offset + 5) ? null : cursor.getShort(offset + 5) != 0);
        entity.setSent(cursor.isNull(offset + 6) ? null : cursor.getShort(offset + 6) != 0);
        entity.setStatus(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setRock7Id(cursor.isNull(offset + 8) ? null : cursor.getLong(offset + 8));
        entity.setLat(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
        entity.setLon(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setTosendOrder(cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11));
     }
    
    /** @inheritdoc */
    @Override
    protected Long updateKeyAfterInsert(Chat entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    /** @inheritdoc */
    @Override
    public Long getKey(Chat entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
}
