package com.cc.infosur.db;

import java.io.IOException;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

public class TestAdapter {
	protected static final String TAG = "DataAdapter";

	private final Context mContext;
	private SQLiteDatabase mDb;
	private DataBaseHelper mDbHelper;

	public TestAdapter(Context context, String name) {
		this.mContext = context;
		mDbHelper = new DataBaseHelper(mContext, name);
	}

	public TestAdapter createDatabase(String folder, String name) throws SQLException {
		try {
			mDbHelper.createDataBase(folder, name);
		} catch (IOException mIOException) {
			Log.e(TAG, mIOException.toString() + "  UnableToCreateDatabase");
			throw new Error("UnableToCreateDatabase");
		}
		return this;
	}

	public TestAdapter open(String name) throws SQLException {
		try {
			mDbHelper.openDataBase(name);
			mDbHelper.close();
			mDb = mDbHelper.getWritableDatabase();
		} catch (SQLException mSQLException) {
			Log.e(TAG, "open >>" + mSQLException.toString());
			throw mSQLException;
		}
		return this;

	}

	public void close() {
		mDbHelper.close();
	}

	public Cursor copyRoutingDataBase() {
		try {

			DataBaseHelper mDbHelper2 = new DataBaseHelper(mContext, "tripkgalagadi");

			SQLiteDatabase db2 = mDbHelper2.opendatabase("tripdb");
			db2.execSQL("ATTACH '"+mDb.getPath()+"' AS tempDb");
			db2.execSQL("DROP TABLE IF EXISTS FLORA");
			db2.execSQL("DROP TABLE IF EXISTS FAUNA");
			db2.execSQL("DROP TABLE IF EXISTS HERITAGE");
			db2.execSQL("DROP TABLE IF EXISTS DETAIL");
			db2.execSQL("DROP TABLE IF EXISTS DB_LINE");
			db2.execSQL("DROP TABLE IF EXISTS DB_POINT");
			db2.execSQL("DROP TABLE IF EXISTS DB_POLYGON");
			db2.execSQL("CREATE TABLE FLORA AS SELECT * FROM tempDb.FLORA");
			db2.execSQL("CREATE TABLE FAUNA AS SELECT * FROM tempDb.FAUNA");
			db2.execSQL("CREATE TABLE HERITAGE AS SELECT * FROM tempDb.HERITAGE");
			db2.execSQL("CREATE TABLE DETAIL AS SELECT * FROM tempDb.DETAIL");
			db2.execSQL("CREATE TABLE DB_LINE AS SELECT * FROM tempDb.DB_LINE");
			db2.execSQL("CREATE TABLE DB_POINT AS SELECT * FROM tempDb.DB_POINT");
			db2.execSQL("CREATE TABLE DB_POLYGON AS SELECT * FROM tempDb.DB_POLYGON");
			db2.execSQL("DETACH tempDb"); 
			db2.close();

			return null;
		} catch (SQLException mSQLException) {
			Log.e(TAG, "getTestData >>" + mSQLException.toString());
			throw mSQLException;
		}
	}
}