/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.write;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryConstants;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;
import org.apache.sanselan.formats.tiff.write.TiffOutputSummary;

public abstract class TiffImageWriterBase
implements TiffConstants,
BinaryConstants {
    protected final int byteOrder;

    public TiffImageWriterBase() {
        this.byteOrder = 73;
    }

    public TiffImageWriterBase(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    protected static final int imageDataPaddingLength(int dataLength) {
        return (4 - dataLength % 4) % 4;
    }

    public abstract void write(OutputStream var1, TiffOutputSet var2) throws IOException, ImageWriteException;

    protected TiffOutputSummary validateDirectories(TiffOutputSet outputSet) throws ImageWriteException {
        List directories = outputSet.getDirectories();
        if (1 > directories.size()) {
            throw new ImageWriteException("No directories.");
        }
        TiffOutputDirectory exifDirectory = null;
        TiffOutputDirectory gpsDirectory = null;
        TiffOutputDirectory interoperabilityDirectory = null;
        TiffOutputField exifDirectoryOffsetField = null;
        TiffOutputField gpsDirectoryOffsetField = null;
        TiffOutputField interoperabilityDirectoryOffsetField = null;
        ArrayList<Integer> directoryIndices = new ArrayList<Integer>();
        HashMap<Integer, TiffOutputDirectory> directoryTypeMap = new HashMap<Integer, TiffOutputDirectory>();
        for (int i = 0; i < directories.size(); ++i) {
            TiffOutputDirectory directory;
            block33: {
                Integer key;
                int dirType;
                block32: {
                    directory = (TiffOutputDirectory)directories.get(i);
                    dirType = directory.type;
                    key = new Integer(dirType);
                    directoryTypeMap.put(key, directory);
                    if (dirType >= 0) break block32;
                    switch (dirType) {
                        case -2: {
                            if (exifDirectory != null) {
                                throw new ImageWriteException("More than one EXIF directory.");
                            }
                            exifDirectory = directory;
                            break block33;
                        }
                        case -3: {
                            if (gpsDirectory != null) {
                                throw new ImageWriteException("More than one GPS directory.");
                            }
                            gpsDirectory = directory;
                            break block33;
                        }
                        case -4: {
                            if (interoperabilityDirectory != null) {
                                throw new ImageWriteException("More than one Interoperability directory.");
                            }
                            interoperabilityDirectory = directory;
                            break block33;
                        }
                        default: {
                            throw new ImageWriteException("Unknown directory: " + dirType);
                        }
                    }
                }
                if (directoryIndices.contains(key)) {
                    throw new ImageWriteException("More than one directory with index: " + dirType + "");
                }
                directoryIndices.add(new Integer(dirType));
            }
            HashSet<Integer> fieldTags = new HashSet<Integer>();
            ArrayList fields = directory.getFields();
            for (int j = 0; j < fields.size(); ++j) {
                TiffOutputField field = (TiffOutputField)fields.get(j);
                Integer fieldKey = new Integer(field.tag);
                if (fieldTags.contains(fieldKey)) {
                    throw new ImageWriteException("Tag (" + field.tagInfo.getDescription() + ") appears twice in directory.");
                }
                fieldTags.add(fieldKey);
                if (field.tag == TiffImageWriterBase.EXIF_TAG_EXIF_OFFSET.tag) {
                    if (exifDirectoryOffsetField != null) {
                        throw new ImageWriteException("More than one Exif directory offset field.");
                    }
                    exifDirectoryOffsetField = field;
                    continue;
                }
                if (field.tag == TiffImageWriterBase.EXIF_TAG_INTEROP_OFFSET.tag) {
                    if (interoperabilityDirectoryOffsetField != null) {
                        throw new ImageWriteException("More than one Interoperability directory offset field.");
                    }
                    interoperabilityDirectoryOffsetField = field;
                    continue;
                }
                if (field.tag != TiffImageWriterBase.EXIF_TAG_GPSINFO.tag) continue;
                if (gpsDirectoryOffsetField != null) {
                    throw new ImageWriteException("More than one GPS directory offset field.");
                }
                gpsDirectoryOffsetField = field;
            }
        }
        if (directoryIndices.size() < 1) {
            throw new ImageWriteException("Missing root directory.");
        }
        Collections.sort(directoryIndices);
        TiffOutputDirectory previousDirectory = null;
        for (int i = 0; i < directoryIndices.size(); ++i) {
            Integer index = (Integer)directoryIndices.get(i);
            if (index != i) {
                throw new ImageWriteException("Missing directory: " + i + "");
            }
            TiffOutputDirectory directory = (TiffOutputDirectory)directoryTypeMap.get(index);
            if (null != previousDirectory) {
                previousDirectory.setNextDirectory(directory);
            }
            previousDirectory = directory;
        }
        TiffOutputDirectory rootDirectory = (TiffOutputDirectory)directoryTypeMap.get(new Integer(0));
        TiffOutputSummary result = new TiffOutputSummary(this.byteOrder, rootDirectory, directoryTypeMap);
        if (interoperabilityDirectory == null && interoperabilityDirectoryOffsetField != null) {
            throw new ImageWriteException("Output set has Interoperability Directory Offset field, but no Interoperability Directory");
        }
        if (interoperabilityDirectory != null) {
            if (exifDirectory == null) {
                exifDirectory = outputSet.addExifDirectory();
            }
            if (interoperabilityDirectoryOffsetField == null) {
                interoperabilityDirectoryOffsetField = TiffOutputField.createOffsetField(EXIF_TAG_INTEROP_OFFSET, this.byteOrder);
                exifDirectory.add(interoperabilityDirectoryOffsetField);
            }
            result.add(interoperabilityDirectory, interoperabilityDirectoryOffsetField);
        }
        if (exifDirectory == null && exifDirectoryOffsetField != null) {
            throw new ImageWriteException("Output set has Exif Directory Offset field, but no Exif Directory");
        }
        if (exifDirectory != null) {
            if (exifDirectoryOffsetField == null) {
                exifDirectoryOffsetField = TiffOutputField.createOffsetField(EXIF_TAG_EXIF_OFFSET, this.byteOrder);
                rootDirectory.add(exifDirectoryOffsetField);
            }
            result.add(exifDirectory, exifDirectoryOffsetField);
        }
        if (gpsDirectory == null && gpsDirectoryOffsetField != null) {
            throw new ImageWriteException("Output set has GPS Directory Offset field, but no GPS Directory");
        }
        if (gpsDirectory != null) {
            if (gpsDirectoryOffsetField == null) {
                gpsDirectoryOffsetField = TiffOutputField.createOffsetField(EXIF_TAG_GPSINFO, this.byteOrder);
                rootDirectory.add(gpsDirectoryOffsetField);
            }
            result.add(gpsDirectory, gpsDirectoryOffsetField);
        }
        return result;
    }

    protected void writeImageFileHeader(BinaryOutputStream bos) throws IOException, ImageWriteException {
        int offsetToFirstIFD = 8;
        this.writeImageFileHeader(bos, offsetToFirstIFD);
    }

    protected void writeImageFileHeader(BinaryOutputStream bos, int offsetToFirstIFD) throws IOException, ImageWriteException {
        bos.write(this.byteOrder);
        bos.write(this.byteOrder);
        bos.write2Bytes(42);
        bos.write4Bytes(offsetToFirstIFD);
    }
}

