/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.sanselan.FormatCompliance;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.tiff.TiffContents;
import org.apache.sanselan.formats.tiff.TiffDirectory;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.TiffReader;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;

public class TiffImageParser
extends ImageParser
implements TiffConstants {
    private static final String DEFAULT_EXTENSION = ".tif";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".tif", ".tiff"};

    public String getName() {
        return "Tiff-Custom";
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_TIFF};
    }

    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readFirstDirectory(byteSource, params, false, formatCompliance);
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        TiffField field = directory.findField(EXIF_TAG_ICC_PROFILE);
        if (null == field) {
            return null;
        }
        return field.oversizeValue;
    }

    public int[] getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readFirstDirectory(byteSource, params, false, formatCompliance);
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        int width = directory.findField(TIFF_TAG_IMAGE_WIDTH).getIntValue();
        int height = directory.findField(TIFF_TAG_IMAGE_LENGTH).getIntValue();
        return new int[]{width, height};
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readContents(byteSource, params, formatCompliance);
        ArrayList directories = contents.directories;
        TiffImageMetadata result = new TiffImageMetadata(contents);
        for (int i = 0; i < directories.size(); ++i) {
            TiffDirectory dir = (TiffDirectory)directories.get(i);
            TiffImageMetadata.Directory metadataDirectory = new TiffImageMetadata.Directory(dir);
            ArrayList entries = dir.getDirectoryEntrys();
            for (int j = 0; j < entries.size(); ++j) {
                TiffField entry = (TiffField)entries.get(j);
                metadataDirectory.add(entry);
            }
            result.add(metadataDirectory);
        }
        return result;
    }

    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        String compressionAlgorithm;
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readDirectories(byteSource, false, formatCompliance);
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        TiffField widthField = directory.findField(TIFF_TAG_IMAGE_WIDTH, true);
        TiffField heightField = directory.findField(TIFF_TAG_IMAGE_LENGTH, true);
        if (widthField == null || heightField == null) {
            throw new ImageReadException("TIFF image missing size info.");
        }
        int height = heightField.getIntValue();
        int width = widthField.getIntValue();
        TiffField resolutionUnitField = directory.findField(TIFF_TAG_RESOLUTION_UNIT);
        int resolutionUnit = 2;
        if (resolutionUnitField != null && resolutionUnitField.getValue() != null) {
            resolutionUnit = resolutionUnitField.getIntValue();
        }
        double unitsPerInch = -1.0;
        switch (resolutionUnit) {
            case 1: {
                break;
            }
            case 2: {
                unitsPerInch = 1.0;
                break;
            }
            case 3: {
                unitsPerInch = 0.0254;
                break;
            }
        }
        TiffField xResolutionField = directory.findField(TIFF_TAG_XRESOLUTION);
        TiffField yResolutionField = directory.findField(TIFF_TAG_YRESOLUTION);
        int physicalWidthDpi = -1;
        float physicalWidthInch = -1.0f;
        int physicalHeightDpi = -1;
        float physicalHeightInch = -1.0f;
        if (unitsPerInch > 0.0) {
            if (xResolutionField != null && xResolutionField.getValue() != null) {
                double XResolutionPixelsPerUnit = xResolutionField.getDoubleValue();
                physicalWidthDpi = (int)(XResolutionPixelsPerUnit / unitsPerInch);
                physicalWidthInch = (float)((double)width / (XResolutionPixelsPerUnit * unitsPerInch));
            }
            if (yResolutionField != null && yResolutionField.getValue() != null) {
                double YResolutionPixelsPerUnit = yResolutionField.getDoubleValue();
                physicalHeightDpi = (int)(YResolutionPixelsPerUnit / unitsPerInch);
                physicalHeightInch = (float)((double)height / (YResolutionPixelsPerUnit * unitsPerInch));
            }
        }
        TiffField bitsPerSampleField = directory.findField(TIFF_TAG_BITS_PER_SAMPLE);
        int bitsPerSample = -1;
        if (bitsPerSampleField != null && bitsPerSampleField.getValue() != null) {
            bitsPerSample = bitsPerSampleField.getIntValueOrArraySum();
        }
        int bitsPerPixel = bitsPerSample;
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList entries = directory.entries;
        for (int i = 0; i < entries.size(); ++i) {
            TiffField field = (TiffField)entries.get(i);
            String comment = field.toString();
            comments.add(comment);
        }
        ImageFormat format = ImageFormat.IMAGE_FORMAT_TIFF;
        String formatName = "TIFF Tag-based Image File Format";
        String mimeType = "image/tiff";
        int numberOfImages = contents.directories.size();
        boolean isProgressive = false;
        String formatDetails = "Tiff v." + contents.header.tiffVersion;
        boolean isTransparent = false;
        boolean usesPalette = false;
        TiffField colorMapField = directory.findField(TIFF_TAG_COLOR_MAP);
        if (colorMapField != null) {
            usesPalette = true;
        }
        int colorType = 2;
        int compression = directory.findField(TIFF_TAG_COMPRESSION).getIntValue();
        switch (compression) {
            case 1: {
                compressionAlgorithm = "None";
                break;
            }
            case 2: {
                compressionAlgorithm = "CCITT 1D";
                break;
            }
            case 3: {
                compressionAlgorithm = "CCITT Group 3 1-Dimensional Modified Huffman run-length encoding.";
                break;
            }
            case 4: {
                compressionAlgorithm = "CCITT Group 4";
                break;
            }
            case 5: {
                compressionAlgorithm = "LZW";
                break;
            }
            case 6: {
                compressionAlgorithm = "JPEG";
                break;
            }
            case 32771: {
                compressionAlgorithm = "None";
                break;
            }
            case 32773: {
                compressionAlgorithm = "PackBits";
                break;
            }
            default: {
                compressionAlgorithm = "Unknown";
            }
        }
        ImageInfo result = new ImageInfo(formatDetails, bitsPerPixel, comments, format, formatName, height, mimeType, numberOfImages, physicalHeightDpi, physicalHeightInch, physicalWidthDpi, physicalWidthInch, width, isProgressive, isTransparent, usesPalette, colorType, compressionAlgorithm);
        return result;
    }

    public String getXmpXml(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readDirectories(byteSource, false, formatCompliance);
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        TiffField xmpField = directory.findField(TIFF_TAG_XMP, false);
        if (xmpField == null) {
            return null;
        }
        byte[] bytes = xmpField.getByteArrayValue();
        try {
            String xml = new String(bytes, "utf-8");
            return xml;
        }
        catch (UnsupportedEncodingException e) {
            throw new ImageReadException("Invalid JPEG XMP Segment.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        try {
            pw.println("tiff.dumpImageFile");
            ImageInfo imageData = this.getImageInfo(byteSource);
            if (imageData == null) {
                boolean bl = false;
                return bl;
            }
            imageData.toString(pw, "");
            pw.println("");
            FormatCompliance formatCompliance = FormatCompliance.getDefault();
            Map params = null;
            TiffContents contents = new TiffReader(true).readContents(byteSource, params, formatCompliance);
            ArrayList directories = contents.directories;
            if (directories == null) {
                boolean bl = false;
                return bl;
            }
            for (int d = 0; d < directories.size(); ++d) {
                TiffDirectory directory = (TiffDirectory)directories.get(d);
                ArrayList entries = directory.entries;
                if (entries == null) {
                    boolean bl = false;
                    return bl;
                }
                for (int i = 0; i < entries.size(); ++i) {
                    TiffField field = (TiffField)entries.get(i);
                    field.dump(pw, d + "");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            pw.println("");
        }
    }

    public FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        Map params = null;
        new TiffReader(TiffImageParser.isStrict(params)).readContents(byteSource, params, formatCompliance);
        return formatCompliance;
    }

    public List collectRawImageData(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readDirectories(byteSource, true, formatCompliance);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i = 0; i < contents.directories.size(); ++i) {
            TiffDirectory directory = (TiffDirectory)contents.directories.get(i);
            ArrayList dataElements = directory.getTiffRawImageDataElements();
            for (int j = 0; j < dataElements.size(); ++j) {
                TiffDirectory.ImageDataElement element = (TiffDirectory.ImageDataElement)dataElements.get(j);
                byte[] bytes = byteSource.getBlock(element.offset, element.length);
                result.add(bytes);
            }
        }
        return result;
    }
}

