/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.tiff.JpegImageData;
import org.apache.sanselan.formats.tiff.TiffElement;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;

public class TiffDirectory
extends TiffElement
implements TiffConstants {
    public final int type;
    public final ArrayList entries;
    public final int nextDirectoryOffset;
    private JpegImageData jpegImageData = null;

    public String description() {
        return TiffDirectory.description(this.type);
    }

    public String getElementDescription(boolean verbose) {
        if (!verbose) {
            return "TIFF Directory (" + this.description() + ")";
        }
        int entryOffset = this.offset + 2;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.entries.size(); ++i) {
            TiffField entry = (TiffField)this.entries.get(i);
            result.append("\t");
            result.append("[" + entryOffset + "]: ");
            result.append(entry.tagInfo.name);
            result.append(" (" + entry.tag + ", 0x" + Integer.toHexString(entry.tag) + ")");
            result.append(", " + entry.fieldType.name);
            result.append(", " + entry.fieldType.getRawBytes(entry).length);
            result.append(": " + entry.getValueDescription());
            result.append("\n");
            entryOffset += 12;
        }
        return result.toString();
    }

    public static final String description(int type) {
        switch (type) {
            case -1: {
                return "Unknown";
            }
            case 0: {
                return "Root";
            }
            case 1: {
                return "Sub";
            }
            case 2: {
                return "Thumbnail";
            }
            case -2: {
                return "Exif";
            }
            case -3: {
                return "Gps";
            }
            case -4: {
                return "Interoperability";
            }
        }
        return "Bad Type";
    }

    public TiffDirectory(int type, ArrayList entries, int offset, int nextDirectoryOffset) {
        super(offset, 2 + entries.size() * 12 + 4);
        this.type = type;
        this.entries = entries;
        this.nextDirectoryOffset = nextDirectoryOffset;
    }

    public ArrayList getDirectoryEntrys() {
        return new ArrayList(this.entries);
    }

    protected void fillInValues(ByteSource byteSource) throws ImageReadException, IOException {
        for (int i = 0; i < this.entries.size(); ++i) {
            TiffField entry = (TiffField)this.entries.get(i);
            entry.fillInValue(byteSource);
        }
    }

    public void dump() {
        for (int i = 0; i < this.entries.size(); ++i) {
            TiffField entry = (TiffField)this.entries.get(i);
            entry.dump();
        }
    }

    public boolean hasJpegImageData() throws ImageReadException {
        return null != this.findField(TIFF_TAG_JPEG_INTERCHANGE_FORMAT);
    }

    public boolean hasTiffImageData() throws ImageReadException {
        if (null != this.findField(TIFF_TAG_TILE_OFFSETS)) {
            return true;
        }
        return null != this.findField(TIFF_TAG_STRIP_OFFSETS);
    }

    public TiffField findField(TagInfo tag) throws ImageReadException {
        boolean failIfMissing = false;
        return this.findField(tag, failIfMissing);
    }

    public TiffField findField(TagInfo tag, boolean failIfMissing) throws ImageReadException {
        if (this.entries == null) {
            return null;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            TiffField field = (TiffField)this.entries.get(i);
            if (field.tag != tag.tag) continue;
            return field;
        }
        if (failIfMissing) {
            throw new ImageReadException("Missing expected field: " + tag.getDescription());
        }
        return null;
    }

    private ArrayList getRawImageDataElements(TiffField offsetsField, TiffField byteCountsField) throws ImageReadException {
        int[] byteCounts;
        int[] offsets = offsetsField.getIntArrayValue();
        if (offsets.length != (byteCounts = byteCountsField.getIntArrayValue()).length) {
            throw new ImageReadException("offsets.length(" + offsets.length + ") != byteCounts.length(" + byteCounts.length + ")");
        }
        ArrayList<ImageDataElement> result = new ArrayList<ImageDataElement>();
        for (int i = 0; i < offsets.length; ++i) {
            result.add(new ImageDataElement(offsets[i], byteCounts[i]));
        }
        return result;
    }

    public ArrayList getTiffRawImageDataElements() throws ImageReadException {
        TiffField tileOffsets = this.findField(TIFF_TAG_TILE_OFFSETS);
        TiffField tileByteCounts = this.findField(TIFF_TAG_TILE_BYTE_COUNTS);
        TiffField stripOffsets = this.findField(TIFF_TAG_STRIP_OFFSETS);
        TiffField stripByteCounts = this.findField(TIFF_TAG_STRIP_BYTE_COUNTS);
        if (tileOffsets != null && tileByteCounts != null) {
            return this.getRawImageDataElements(tileOffsets, tileByteCounts);
        }
        if (stripOffsets != null && stripByteCounts != null) {
            return this.getRawImageDataElements(stripOffsets, stripByteCounts);
        }
        throw new ImageReadException("Couldn't find image data.");
    }

    public boolean imageDataInStrips() throws ImageReadException {
        TiffField tileOffsets = this.findField(TIFF_TAG_TILE_OFFSETS);
        TiffField tileByteCounts = this.findField(TIFF_TAG_TILE_BYTE_COUNTS);
        TiffField stripOffsets = this.findField(TIFF_TAG_STRIP_OFFSETS);
        TiffField stripByteCounts = this.findField(TIFF_TAG_STRIP_BYTE_COUNTS);
        if (tileOffsets != null && tileByteCounts != null) {
            return false;
        }
        if (stripOffsets != null && stripByteCounts != null) {
            return true;
        }
        if (stripOffsets != null && stripByteCounts != null) {
            return true;
        }
        throw new ImageReadException("Couldn't find image data.");
    }

    public ImageDataElement getJpegRawImageDataElement() throws ImageReadException {
        TiffField jpegInterchangeFormat = this.findField(TIFF_TAG_JPEG_INTERCHANGE_FORMAT);
        TiffField jpegInterchangeFormatLength = this.findField(TIFF_TAG_JPEG_INTERCHANGE_FORMAT_LENGTH);
        if (jpegInterchangeFormat != null && jpegInterchangeFormatLength != null) {
            int offset = jpegInterchangeFormat.getIntArrayValue()[0];
            int byteCount = jpegInterchangeFormatLength.getIntArrayValue()[0];
            return new ImageDataElement(offset, byteCount);
        }
        throw new ImageReadException("Couldn't find image data.");
    }

    public void setJpegImageData(JpegImageData value) {
        this.jpegImageData = value;
    }

    public JpegImageData getJpegImageData() {
        return this.jpegImageData;
    }

    public final class ImageDataElement
    extends TiffElement {
        public ImageDataElement(int offset, int length) {
            super(offset, length);
        }

        public String getElementDescription(boolean verbose) {
            if (verbose) {
                return null;
            }
            return "ImageDataElement";
        }
    }
}

