/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.util.Debug;

public class JpegImageMetadata
implements IImageMetadata {
    private final TiffImageMetadata exif;
    private static final String newline = System.getProperty("line.separator");

    public JpegImageMetadata(Object photoshop, TiffImageMetadata exif) {
        this.exif = exif;
    }

    public TiffImageMetadata getExif() {
        return this.exif;
    }

    public TiffField findEXIFValue(TagInfo tagInfo) {
        ArrayList items = this.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Object o = items.get(i);
            if (!(o instanceof TiffImageMetadata.Item)) continue;
            TiffImageMetadata.Item item = (TiffImageMetadata.Item)o;
            TiffField field = item.getTiffField();
            if (field.tag != tagInfo.tag) continue;
            return field;
        }
        return null;
    }

    public Object getEXIFThumbnail() throws ImageReadException, IOException {
        return null;
    }

    public ArrayList getItems() {
        ArrayList result = new ArrayList();
        if (null != this.exif) {
            result.addAll(this.exif.getItems());
        }
        return result;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        StringBuffer result = new StringBuffer();
        result.append(prefix);
        if (null == this.exif) {
            result.append("No Exif metadata.");
        } else {
            result.append("Exif metadata:");
            result.append(newline);
            result.append(this.exif.toString("\t"));
        }
        result.append(newline);
        result.append(prefix);
        result.append("No Photoshop (IPTC) metadata.");
        return result.toString();
    }

    public void dump() {
        Debug.debug(this.toString());
    }
}

