/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.SanselanConstants;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceArray;
import org.apache.sanselan.common.byteSources.ByteSourceFile;
import org.apache.sanselan.common.byteSources.ByteSourceInputStream;
import org.apache.sanselan.util.Debug;

public abstract class Sanselan
implements SanselanConstants {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFormat guessFormat(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            int i1 = is.read();
            int i2 = is.read();
            if (i1 < 0 || i2 < 0) {
                throw new ImageReadException("Couldn't read magic numbers to guess format.");
            }
            int b1 = i1 & 0xFF;
            int b2 = i2 & 0xFF;
            if (b1 == 71 && b2 == 73) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_GIF;
                return imageFormat;
            }
            if (b1 == 137 && b2 == 80) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_PNG;
                return imageFormat;
            }
            if (b1 == 255 && b2 == 216) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_JPEG;
                return imageFormat;
            }
            if (b1 == 66 && b2 == 77) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_BMP;
                return imageFormat;
            }
            if (b1 == 77 && b2 == 77) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_TIFF;
                return imageFormat;
            }
            if (b1 == 73 && b2 == 73) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_TIFF;
                return imageFormat;
            }
            if (b1 == 56 && b2 == 66) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_PSD;
                return imageFormat;
            }
            if (b1 == 80 && b2 == 49) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_PBM;
                return imageFormat;
            }
            if (b1 == 80 && b2 == 52) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_PBM;
                return imageFormat;
            }
            if (b1 == 80 && b2 == 50) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_PGM;
                return imageFormat;
            }
            if (b1 == 80 && b2 == 53) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_PGM;
                return imageFormat;
            }
            if (b1 == 80 && b2 == 51) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_PPM;
                return imageFormat;
            }
            if (b1 == 80 && b2 == 54) {
                ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_PPM;
                return imageFormat;
            }
            if (b1 == 151 && b2 == 74) {
                int i3 = is.read();
                int i4 = is.read();
                if (i3 < 0 || i4 < 0) {
                    throw new ImageReadException("Couldn't read magic numbers to guess format.");
                }
                int b3 = i3 & 0xFF;
                int b4 = i4 & 0xFF;
                if (b3 == 66 && b4 == 50) {
                    ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_JBIG2;
                    return imageFormat;
                }
            }
            ImageFormat imageFormat = ImageFormat.IMAGE_FORMAT_UNKNOWN;
            return imageFormat;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Debug.debug(e);
                }
            }
        }
    }

    private static final ImageParser getImageParser(ByteSource byteSource) throws ImageReadException, IOException {
        String filename;
        ImageFormat format = Sanselan.guessFormat(byteSource);
        if (!format.equals(ImageFormat.IMAGE_FORMAT_UNKNOWN)) {
            ImageParser[] imageParsers = ImageParser.getAllImageParsers();
            for (int i = 0; i < imageParsers.length; ++i) {
                ImageParser imageParser = imageParsers[i];
                if (!imageParser.canAcceptType(format)) continue;
                return imageParser;
            }
        }
        if ((filename = byteSource.getFilename()) != null) {
            ImageParser[] imageParsers = ImageParser.getAllImageParsers();
            for (int i = 0; i < imageParsers.length; ++i) {
                ImageParser imageParser = imageParsers[i];
                if (!imageParser.canAcceptExtension(filename)) continue;
                return imageParser;
            }
        }
        throw new ImageReadException("Can't parse this format.");
    }

    public static IImageMetadata getMetadata(byte[] bytes) throws ImageReadException, IOException {
        return Sanselan.getMetadata(bytes, null);
    }

    public static IImageMetadata getMetadata(byte[] bytes, Map params) throws ImageReadException, IOException {
        return Sanselan.getMetadata(new ByteSourceArray(bytes), params);
    }

    public static IImageMetadata getMetadata(InputStream is, String filename) throws ImageReadException, IOException {
        return Sanselan.getMetadata(is, filename, null);
    }

    public static IImageMetadata getMetadata(InputStream is, String filename, Map params) throws ImageReadException, IOException {
        return Sanselan.getMetadata(new ByteSourceInputStream(is, filename), params);
    }

    public static IImageMetadata getMetadata(File file) throws ImageReadException, IOException {
        return Sanselan.getMetadata(file, null);
    }

    public static IImageMetadata getMetadata(File file, Map params) throws ImageReadException, IOException {
        return Sanselan.getMetadata(new ByteSourceFile(file), params);
    }

    private static IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        ImageParser imageParser = Sanselan.getImageParser(byteSource);
        return imageParser.getMetadata(byteSource, params);
    }
}

