/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.utils;

import java.util.ArrayList;
import org.osmdroid.util.GeoPoint;

public class PolylineEncoder {
    private static StringBuffer encodeSignedNumber(int num) {
        int sgn_num = num << 1;
        if (num < 0) {
            sgn_num ^= 0xFFFFFFFF;
        }
        return PolylineEncoder.encodeNumber(sgn_num);
    }

    private static StringBuffer encodeNumber(int num) {
        StringBuffer encodeString = new StringBuffer();
        while (num >= 32) {
            int nextValue = (0x20 | num & 0x1F) + 63;
            encodeString.append((char)nextValue);
            num >>= 5;
        }
        encodeString.append((char)(num += 63));
        return encodeString;
    }

    public static String encode(ArrayList<GeoPoint> polyline, int precision) {
        StringBuffer encodedPoints = new StringBuffer();
        int prev_lat = 0;
        int prev_lng = 0;
        for (GeoPoint trackpoint : polyline) {
            int lat = trackpoint.getLatitudeE6() / precision;
            int lng = trackpoint.getLongitudeE6() / precision;
            encodedPoints.append(PolylineEncoder.encodeSignedNumber(lat - prev_lat));
            encodedPoints.append(PolylineEncoder.encodeSignedNumber(lng - prev_lng));
            prev_lat = lat;
            prev_lng = lng;
        }
        return encodedPoints.toString();
    }

    public static ArrayList<GeoPoint> decode(String encodedString, int precision) {
        int index = 0;
        int len = encodedString.length();
        int lat = 0;
        int lng = 0;
        ArrayList<GeoPoint> polyline = new ArrayList<GeoPoint>(len / 3);
        while (index < len) {
            int b;
            int shift = 0;
            int result = 0;
            do {
                b = encodedString.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int dlat = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            lat += dlat;
            shift = 0;
            result = 0;
            do {
                b = encodedString.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int dlng = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            GeoPoint p = new GeoPoint(lat * precision, (lng += dlng) * precision);
            polyline.add(p);
        }
        return polyline;
    }
}

