/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.utils;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class HttpConnection {
    private DefaultHttpClient client;
    private InputStream stream = null;
    private HttpEntity entity = null;
    private String mUserAgent;
    private static final int TIMEOUT_CONNECTION = 3000;
    private static final int TIMEOUT_SOCKET = 8000;

    public HttpConnection() {
        BasicHttpParams httpParameters = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)3000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)8000);
        this.client = new DefaultHttpClient((HttpParams)httpParameters);
    }

    public void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public void doGet(String sUrl) {
        try {
            HttpResponse response;
            StatusLine status;
            HttpGet request = new HttpGet(sUrl);
            if (this.mUserAgent != null) {
                request.setHeader("User-Agent", this.mUserAgent);
            }
            if ((status = (response = this.client.execute((HttpUriRequest)request)).getStatusLine()).getStatusCode() != 200) {
                Log.e((String)"BONUSPACK", (String)("Invalid response from server: " + status.toString()));
            } else {
                this.entity = response.getEntity();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(String sUrl, List<NameValuePair> nameValuePairs) {
        try {
            HttpPost request = new HttpPost(sUrl);
            if (this.mUserAgent != null) {
                request.setHeader("User-Agent", this.mUserAgent);
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                Log.e((String)"BONUSPACK", (String)("Invalid response from server: " + status.toString()));
            } else {
                this.entity = response.getEntity();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputStream getStream() {
        try {
            if (this.entity != null) {
                this.stream = this.entity.getContent();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.stream;
    }

    public String getContentAsString() {
        try {
            if (this.entity != null) {
                return EntityUtils.toString((HttpEntity)this.entity, (String)"UTF-8");
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.entity != null) {
            try {
                this.entity.consumeContent();
                this.entity = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.client != null) {
            this.client.getConnectionManager().shutdown();
            this.client = null;
        }
    }
}

