/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.utils;

import java.util.ArrayList;
import org.osmdroid.util.GeoPoint;

public class DouglasPeuckerReducer {
    public static ArrayList<GeoPoint> reduceWithTolerance(ArrayList<GeoPoint> shape, double tolerance) {
        int n = shape.size();
        if (tolerance <= 0.0 || n < 3) {
            return shape;
        }
        boolean[] marked = new boolean[n];
        int i = 1;
        while (i < n - 1) {
            marked[i] = false;
            ++i;
        }
        marked[n - 1] = true;
        marked[0] = true;
        DouglasPeuckerReducer.douglasPeuckerReduction(shape, marked, tolerance, 0, n - 1);
        ArrayList<GeoPoint> newShape = new ArrayList<GeoPoint>(n);
        int i2 = 0;
        while (i2 < n) {
            if (marked[i2]) {
                newShape.add(shape.get(i2));
            }
            ++i2;
        }
        return newShape;
    }

    private static void douglasPeuckerReduction(ArrayList<GeoPoint> shape, boolean[] marked, double tolerance, int firstIdx, int lastIdx) {
        if (lastIdx <= firstIdx + 1) {
            return;
        }
        double maxDistance = 0.0;
        int indexFarthest = 0;
        GeoPoint firstPoint = shape.get(firstIdx);
        GeoPoint lastPoint = shape.get(lastIdx);
        int idx = firstIdx + 1;
        while (idx < lastIdx) {
            GeoPoint point = shape.get(idx);
            double distance = DouglasPeuckerReducer.orthogonalDistance(point, firstPoint, lastPoint);
            if (distance > maxDistance) {
                maxDistance = distance;
                indexFarthest = idx;
            }
            ++idx;
        }
        if (maxDistance > tolerance) {
            marked[indexFarthest] = true;
            DouglasPeuckerReducer.douglasPeuckerReduction(shape, marked, tolerance, firstIdx, indexFarthest);
            DouglasPeuckerReducer.douglasPeuckerReduction(shape, marked, tolerance, indexFarthest, lastIdx);
        }
    }

    public static double orthogonalDistance(GeoPoint point, GeoPoint lineStart, GeoPoint lineEnd) {
        double area = Math.abs((1.0 * (double)lineStart.getLatitudeE6() * (double)lineEnd.getLongitudeE6() + 1.0 * (double)lineEnd.getLatitudeE6() * (double)point.getLongitudeE6() + 1.0 * (double)point.getLatitudeE6() * (double)lineStart.getLongitudeE6() - 1.0 * (double)lineEnd.getLatitudeE6() * (double)lineStart.getLongitudeE6() - 1.0 * (double)point.getLatitudeE6() * (double)lineEnd.getLongitudeE6() - 1.0 * (double)lineStart.getLatitudeE6() * (double)point.getLongitudeE6()) / 2.0);
        double bottom = Math.hypot(lineStart.getLatitudeE6() - lineEnd.getLatitudeE6(), lineStart.getLongitudeE6() - lineEnd.getLongitudeE6());
        return area / bottom * 2.0;
    }
}

