/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import org.apache.http.NameValuePair;
import org.osmdroid.bonuspack.utils.HttpConnection;

public class BonusPackHelper {
    public static final String LOG_TAG = "BONUSPACK";
    public static final String DEFAULT_USER_AGENT = "OsmBonusPack/1";

    public static boolean isEmulator() {
        return "google_sdk".equals(Build.PRODUCT) || "sdk".equals(Build.PRODUCT);
    }

    private static String readStream(HttpConnection connection) {
        String result = connection.getContentAsString();
        return result;
    }

    public static String requestStringFromUrl(String url) {
        HttpConnection connection = new HttpConnection();
        connection.doGet(url);
        String result = BonusPackHelper.readStream(connection);
        connection.close();
        return result;
    }

    public static String requestStringFromPost(String url, List<NameValuePair> nameValuePairs) {
        HttpConnection connection = new HttpConnection();
        connection.doPost(url, nameValuePairs);
        String result = BonusPackHelper.readStream(connection);
        connection.close();
        return result;
    }

    public static String convertStreamToString(InputStream is) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        reader.close();
        return sb.toString();
    }

    public static Bitmap loadBitmap(String url) {
        InputStream is;
        Bitmap bitmap2;
        block3: {
            bitmap2 = null;
            try {
                is = (InputStream)new URL(url).getContent();
                if (is != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        bitmap2 = BitmapFactory.decodeStream((InputStream)new FlushedInputStream(is));
        return bitmap2;
    }

    static class FlushedInputStream
    extends FilterInputStream {
        public FlushedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public long skip(long n) throws IOException {
            long totalBytesSkipped = 0L;
            while (totalBytesSkipped < n) {
                long bytesSkipped = this.in.skip(n - totalBytesSkipped);
                if (bytesSkipped == 0L) {
                    int byteValue = this.read();
                    if (byteValue < 0) break;
                    bytesSkipped = 1L;
                }
                totalBytesSkipped += bytesSkipped;
            }
            return totalBytesSkipped;
        }
    }
}

