/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.content.Context;
import java.util.ArrayList;
import org.osmdroid.bonuspack.overlays.Polyline;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.util.GeoPoint;

public abstract class RoadManager {
    protected String mOptions = "";

    public abstract Road getRoad(ArrayList<GeoPoint> var1);

    public void addRequestOption(String requestOption) {
        this.mOptions = String.valueOf(this.mOptions) + "&" + requestOption;
    }

    protected String geoPointAsString(GeoPoint p) {
        StringBuffer result = new StringBuffer();
        double d = (double)p.getLatitudeE6() * 1.0E-6;
        result.append(Double.toString(d));
        d = (double)p.getLongitudeE6() * 1.0E-6;
        result.append("," + Double.toString(d));
        return result.toString();
    }

    public static Polyline buildRoadOverlay(Road road, int color, float width, Context context) {
        Polyline roadOverlay = new Polyline(context);
        roadOverlay.setColor(color);
        roadOverlay.setWidth(width);
        if (road != null) {
            ArrayList<GeoPoint> polyline = road.mRouteHigh;
            roadOverlay.setPoints(polyline);
        }
        return roadOverlay;
    }

    public static Polyline buildRoadOverlay(Road road, Context context) {
        return RoadManager.buildRoadOverlay(road, -2147483393, 5.0f, context);
    }
}

