/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.bonuspack.routing.RoadManager;
import org.osmdroid.bonuspack.routing.RoadNode;
import org.osmdroid.bonuspack.utils.HttpConnection;
import org.osmdroid.bonuspack.utils.PolylineEncoder;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;

public class OSRMRoadManager
extends RoadManager {
    static final String OSRM_SERVICE = "http://router.project-osrm.org/viaroute?";
    protected String mServiceUrl = "http://router.project-osrm.org/viaroute?";
    protected String mUserAgent = "OsmBonusPack/1";
    static final HashMap<String, Integer> MANEUVERS = new HashMap();
    static final HashMap<String, Object> DIRECTIONS;

    static {
        MANEUVERS.put("0", 0);
        MANEUVERS.put("1", 1);
        MANEUVERS.put("2", 6);
        MANEUVERS.put("3", 7);
        MANEUVERS.put("4", 8);
        MANEUVERS.put("5", 12);
        MANEUVERS.put("6", 5);
        MANEUVERS.put("7", 4);
        MANEUVERS.put("8", 3);
        MANEUVERS.put("9", 24);
        MANEUVERS.put("10", 24);
        MANEUVERS.put("11-1", 27);
        MANEUVERS.put("11-2", 28);
        MANEUVERS.put("11-3", 29);
        MANEUVERS.put("11-4", 30);
        MANEUVERS.put("11-5", 31);
        MANEUVERS.put("11-6", 32);
        MANEUVERS.put("11-7", 33);
        MANEUVERS.put("11-8", 34);
        MANEUVERS.put("15", 24);
        DIRECTIONS = new HashMap();
        HashMap<String, String> directions = new HashMap<String, String>();
        DIRECTIONS.put("en", directions);
        directions.put("0", "Unknown instruction< on %s>");
        directions.put("1", "Continue< on %s>");
        directions.put("2", "Turn slight right< on %s>");
        directions.put("3", "Turn right< on %s>");
        directions.put("4", "Turn sharp right< on %s>");
        directions.put("5", "U-Turn< on %s>");
        directions.put("6", "Turn sharp left< on %s>");
        directions.put("7", "Turn left< on %s>");
        directions.put("8", "Turn slight left< on %s>");
        directions.put("9", "You have reached a waypoint of your trip");
        directions.put("10", "<Go on %s>");
        directions.put("11-1", "Enter roundabout and leave at first exit< on %s>");
        directions.put("11-2", "Enter roundabout and leave at second exit< on %s>");
        directions.put("11-3", "Enter roundabout and leave at third exit< on %s>");
        directions.put("11-4", "Enter roundabout and leave at fourth exit< on %s>");
        directions.put("11-5", "Enter roundabout and leave at fifth exit< on %s>");
        directions.put("11-6", "Enter roundabout and leave at sixth exit< on %s>");
        directions.put("11-7", "Enter roundabout and leave at seventh exit< on %s>");
        directions.put("11-8", "Enter roundabout and leave at eighth exit< on %s>");
        directions.put("11-9", "Enter roundabout and leave at nineth exit< on %s>");
        directions.put("15", "You have reached your destination");
        directions = new HashMap();
        DIRECTIONS.put("fr", directions);
        directions.put("0", "Instruction inconnue< sur %s>");
        directions.put("1", "Continuez< sur %s>");
        directions.put("2", "Tournez l\u00e9g\u00e8rement \u00e0 droite< sur %s>");
        directions.put("3", "Tournez \u00e0 droite< sur %s>");
        directions.put("4", "Tournez fortement \u00e0 droite< sur %s>");
        directions.put("5", "Faites demi-tour< sur %s>");
        directions.put("6", "Tournez fortement \u00e0 gauche< sur %s>");
        directions.put("7", "Tournez \u00e0 gauche< sur %s>");
        directions.put("8", "Tournez l\u00e9g\u00e8rement \u00e0 gauche< sur %s>");
        directions.put("9", "Vous \u00eates arriv\u00e9 \u00e0 une \u00e9tape de votre voyage");
        directions.put("10", "<Prenez %s>");
        directions.put("11-1", "Au rond-point, prenez la premi\u00e8re sortie< sur %s>");
        directions.put("11-2", "Au rond-point, prenez la deuxi\u00e8me sortie< sur %s>");
        directions.put("11-3", "Au rond-point, prenez la troisi\u00e8me sortie< sur %s>");
        directions.put("11-4", "Au rond-point, prenez la quatri\u00e8me sortie< sur %s>");
        directions.put("11-5", "Au rond-point, prenez la cinqui\u00e8me sortie< sur %s>");
        directions.put("11-6", "Au rond-point, prenez la sixi\u00e8me sortie< sur %s>");
        directions.put("11-7", "Au rond-point, prenez la septi\u00e8me sortie< sur %s>");
        directions.put("11-8", "Au rond-point, prenez la huiti\u00e8me sortie< sur %s>");
        directions.put("11-9", "Au rond-point, prenez la neuvi\u00e8me sortie< sur %s>");
        directions.put("15", "Vous \u00eates arriv\u00e9");
        directions = new HashMap();
        DIRECTIONS.put("pl", directions);
        directions.put("0", "Nieznana instrukcja<w %s>");
        directions.put("1", "Kontynuuj jazd\u0119<na %s>");
        directions.put("2", "Skr\u0119\u0107 lekko w prawo<w %s>");
        directions.put("3", "Skr\u0119\u0107 w prawo<w %s>");
        directions.put("4", "Skr\u0119\u0107 ostro w prawo<w %s>");
        directions.put("5", "Zawr\u00f3\u0107<na %s>");
        directions.put("6", "Skr\u0119\u0107 ostro w lewo<w %s>");
        directions.put("7", "Skr\u0119\u0107 w lewo<w %s>");
        directions.put("8", "Skr\u0119\u0107 lekko w lewo<w %s>");
        directions.put("9", "Dotar\u0142e\u015b do punktu po\u015bredniego");
        directions.put("10", "<Jed\u017a %s>");
        directions.put("11-1", "Wjed\u017a na rondo i opu\u015b\u0107 je pierwszym zjazdem<w %s>");
        directions.put("11-2", "Wjed\u017a na rondo i opu\u015b\u0107 je drugim zjazdem<w %s>");
        directions.put("11-3", "Wjed\u017a na rondo i opu\u015b\u0107 je trzecim zjazdem<w %s>");
        directions.put("11-4", "Wjed\u017a na rondo i opu\u015b\u0107 je czwartym zjazdem<w %s>");
        directions.put("11-5", "Wjed\u017a na rondo i opu\u015b\u0107 je pi\u0105tym zjazdem<w %s>");
        directions.put("11-6", "Wjed\u017a na rondo i opu\u015b\u0107 je sz\u00f3stym zjazdem<w %s>");
        directions.put("11-7", "Wjed\u017a na rondo i opu\u015b\u0107 je si\u00f3dmym zjazdem<w %s>");
        directions.put("11-8", "Wjed\u017a na rondo i opu\u015b\u0107 je \u00f3smym zjazdem<w %s>");
        directions.put("11-9", "Wjed\u017a na rondo i opu\u015b\u0107 je dziewi\u0105tym zjazdem<w %s>");
        directions.put("15", "Dotar\u0142e\u015b do celu podr\u00f3\u017cy");
        directions = new HashMap();
        DIRECTIONS.put("de", directions);
        directions.put("0", "Unbekannte Instruktion< auf %s>");
        directions.put("1", "Bleiben Sie< auf %s>");
        directions.put("2", "Biegen Sie leicht rechts ab< auf %s>");
        directions.put("3", "Biegen Sie rechts ab< auf %s>");
        directions.put("4", "Biegen Sie scharf rechts ab< auf %s>");
        directions.put("5", "Bitte wenden< auf %s>");
        directions.put("6", "Biegen Sie scharf links ab< auf %s>");
        directions.put("7", "Biegen Sie links ab< auf %s>");
        directions.put("8", "Biegen Sie leicht links ab< auf %s>");
        directions.put("9", "Sie haben einen Wegpunkt ihrer Reise erreicht");
        directions.put("10", "<Begeben Sie sich auf %s>");
        directions.put("11-1", "Begeben Sie sich in den Kreisverkehr und nehmen die erste Ausfahrt< auf %s>");
        directions.put("11-2", "Begeben Sie sich in den Kreisverkehr und nehmen die zweite Ausfahrt< auf %s>");
        directions.put("11-3", "Begeben Sie sich in den Kreisverkehr und nehmen die dritte Ausfahrt< auf %s>");
        directions.put("11-4", "Begeben Sie sich in den Kreisverkehr und nehmen die vierte Ausfahrt< auf %s>");
        directions.put("11-5", "Begeben Sie sich in den Kreisverkehr und nehmen die f\u00fcnfte Ausfahrt< auf %s>");
        directions.put("11-6", "Begeben Sie sich in den Kreisverkehr und nehmen die sechste Ausfahrt< auf %s>");
        directions.put("11-7", "Begeben Sie sich in den Kreisverkehr und nehmen die siebente Ausfahrt< auf %s>");
        directions.put("11-8", "Begeben Sie sich in den Kreisverkehr und nehmen die achte Ausfahrt< auf %s>");
        directions.put("11-9", "Begeben Sie sich in den Kreisverkehr und nehmen die neunte Ausfahrt< auf %s>");
        directions.put("15", "Sie haben ihr Ziel erreicht");
    }

    public void setService(String serviceUrl) {
        this.mServiceUrl = serviceUrl;
    }

    public void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
    }

    protected String getUrl(ArrayList<GeoPoint> waypoints) {
        StringBuffer urlString = new StringBuffer(this.mServiceUrl);
        int i = 0;
        while (i < waypoints.size()) {
            GeoPoint p = waypoints.get(i);
            urlString.append("&loc=" + this.geoPointAsString(p));
            ++i;
        }
        urlString.append("&instructions=true&alt=false");
        urlString.append(this.mOptions);
        return urlString.toString();
    }

    @Override
    public Road getRoad(ArrayList<GeoPoint> waypoints) {
        String url = this.getUrl(waypoints);
        Log.d((String)"BONUSPACK", (String)("OSRMRoadManager.getRoad:" + url));
        HttpConnection connection = new HttpConnection();
        connection.setUserAgent(this.mUserAgent);
        connection.doGet(url);
        String jString = connection.getContentAsString();
        connection.close();
        if (jString == null) {
            Log.e((String)"BONUSPACK", (String)"OSRMRoadManager::getRoad: request failed.");
            return new Road(waypoints);
        }
        Locale l = Locale.getDefault();
        HashMap directions = (HashMap)DIRECTIONS.get(l.getLanguage());
        if (directions == null) {
            directions = (HashMap)DIRECTIONS.get("en");
        }
        Road road = new Road();
        try {
            JSONObject jObject = new JSONObject(jString);
            String route_geometry = jObject.getString("route_geometry");
            road.mRouteHigh = PolylineEncoder.decode(route_geometry, 1);
            JSONArray jInstructions = jObject.getJSONArray("route_instructions");
            int n = jInstructions.length();
            RoadNode lastNode = null;
            int i = 0;
            while (i < n) {
                JSONArray jInstruction = jInstructions.getJSONArray(i);
                RoadNode node = new RoadNode();
                int positionIndex = jInstruction.getInt(3);
                node.mLocation = road.mRouteHigh.get(positionIndex);
                node.mLength = (double)jInstruction.getInt(2) / 1000.0;
                node.mDuration = jInstruction.getInt(4);
                String direction = jInstruction.getString(0);
                String roadName = jInstruction.getString(1);
                if (lastNode != null && "1".equals(direction) && "".equals(roadName)) {
                    lastNode.mLength += node.mLength;
                    lastNode.mDuration += node.mDuration;
                } else {
                    node.mManeuverType = this.getManeuverCode(direction);
                    node.mInstructions = this.buildInstructions(direction, roadName, directions);
                    road.mNodes.add(node);
                    lastNode = node;
                }
                ++i;
            }
            JSONObject jSummary = jObject.getJSONObject("route_summary");
            road.mLength = (double)jSummary.getInt("total_distance") / 1000.0;
            road.mDuration = jSummary.getInt("total_time");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new Road(waypoints);
        }
        if (road.mRouteHigh.size() == 0) {
            road = new Road(waypoints);
        } else {
            road.buildLegs(waypoints);
            road.mBoundingBox = BoundingBoxE6.fromGeoPoints(road.mRouteHigh);
            road.mStatus = 1;
        }
        Log.d((String)"BONUSPACK", (String)"OSRMRoadManager.getRoad - finished");
        return road;
    }

    protected int getManeuverCode(String direction) {
        Integer code = MANEUVERS.get(direction);
        if (code != null) {
            return code;
        }
        return 0;
    }

    protected String buildInstructions(String direction, String roadName, HashMap<String, String> directions) {
        if (directions == null) {
            return null;
        }
        if ((direction = directions.get(direction)) == null) {
            return null;
        }
        String instructions = null;
        if (roadName.equals("")) {
            instructions = direction.replaceFirst("<[^>]*>", "");
        } else {
            direction = direction.replace('<', ' ');
            direction = direction.replace('>', ' ');
            instructions = String.format(direction, roadName);
        }
        return instructions;
    }
}

