/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import java.util.ArrayList;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.bonuspack.routing.RoadLink;
import org.osmdroid.bonuspack.routing.RoadNode;
import org.osmdroid.bonuspack.utils.PolylineEncoder;
import org.osmdroid.util.BoundingBoxE6;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MapQuestGuidanceHandler
extends DefaultHandler {
    public Road mRoad;
    public ArrayList<RoadLink> mLinks;
    boolean isBB = false;
    boolean isGuidanceNodeCollection = false;
    private StringBuilder mStringBuilder = new StringBuilder(1024);
    double mLat;
    double mLng;
    double mNorth;
    double mWest;
    double mSouth;
    double mEast;
    RoadLink mLink;
    RoadNode mNode;

    public MapQuestGuidanceHandler() {
        this.mRoad = new Road();
        this.mLinks = new ArrayList();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName.equals("boundingBox")) {
            this.isBB = true;
        } else if (localName.equals("link")) {
            this.mLink = new RoadLink();
        } else if (localName.equals("node")) {
            this.mNode = new RoadNode();
        } else if (localName.equals("GuidanceNodeCollection")) {
            this.isGuidanceNodeCollection = true;
        }
        this.mStringBuilder.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mStringBuilder.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (localName.equals("lat")) {
            this.mLat = Double.parseDouble(this.mStringBuilder.toString());
        } else if (localName.equals("lng")) {
            this.mLng = Double.parseDouble(this.mStringBuilder.toString());
        } else if (localName.equals("shapePoints")) {
            this.mRoad.mRouteHigh = PolylineEncoder.decode(this.mStringBuilder.toString(), 10);
        } else if (localName.equals("generalizedShape")) {
            this.mRoad.setRouteLow(PolylineEncoder.decode(this.mStringBuilder.toString(), 10));
        } else if (localName.equals("length")) {
            this.mLink.mLength = Double.parseDouble(this.mStringBuilder.toString());
        } else if (localName.equals("speed")) {
            this.mLink.mSpeed = Double.parseDouble(this.mStringBuilder.toString());
        } else if (localName.equals("shapeIndex")) {
            this.mLink.mShapeIndex = Integer.parseInt(this.mStringBuilder.toString());
        } else if (localName.equals("link")) {
            this.mLink.mDuration = this.mLink.mLength / this.mLink.mSpeed * 3600.0;
            this.mLinks.add(this.mLink);
            this.mRoad.mLength += this.mLink.mLength;
            this.mRoad.mDuration += this.mLink.mDuration;
            this.mLink = null;
        } else if (localName.equals("turnCost")) {
            int turnCost = Integer.parseInt(this.mStringBuilder.toString());
            this.mNode.mDuration += (double)turnCost;
            this.mRoad.mDuration += (double)turnCost;
        } else if (localName.equals("maneuverType")) {
            this.mNode.mManeuverType = Integer.parseInt(this.mStringBuilder.toString());
        } else if (localName.equals("info")) {
            if (this.isGuidanceNodeCollection && this.mNode.mInstructions == null) {
                this.mNode.mInstructions = this.mStringBuilder.toString();
            }
        } else if (localName.equals("linkId")) {
            if (this.isGuidanceNodeCollection) {
                this.mNode.mNextRoadLink = Integer.parseInt(this.mStringBuilder.toString());
            }
        } else if (localName.equals("node")) {
            this.mRoad.mNodes.add(this.mNode);
            this.mNode = null;
        } else if (localName.equals("GuidanceNodeCollection")) {
            this.isGuidanceNodeCollection = false;
        } else if (localName.equals("ul")) {
            if (this.isBB) {
                this.mNorth = this.mLat;
                this.mWest = this.mLng;
            }
        } else if (localName.equals("lr")) {
            if (this.isBB) {
                this.mSouth = this.mLat;
                this.mEast = this.mLng;
            }
        } else if (localName.equals("boundingBox")) {
            this.mRoad.mBoundingBox = new BoundingBoxE6(this.mNorth, this.mEast, this.mSouth, this.mWest);
            this.isBB = false;
        }
    }
}

