/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.overlays;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.overlay.PathOverlay;

public class Polyline
extends PathOverlay {
    private int[][] mOriginalPoints;
    protected boolean mGeodesic;

    public Polyline(Context ctx) {
        this((ResourceProxy)new DefaultResourceProxyImpl(ctx));
    }

    public Polyline(ResourceProxy resourceProxy) {
        super(-16777216, 10.0f, resourceProxy);
        this.mPaint.setAntiAlias(true);
        this.mOriginalPoints = new int[0][2];
        this.mGeodesic = false;
    }

    public List<GeoPoint> getPoints() {
        ArrayList<GeoPoint> result = new ArrayList<GeoPoint>(this.mOriginalPoints.length);
        int i = 0;
        while (i < this.mOriginalPoints.length) {
            GeoPoint gp = new GeoPoint(this.mOriginalPoints[i][0], this.mOriginalPoints[i][1]);
            result.add(gp);
            ++i;
        }
        return result;
    }

    public int getColor() {
        return this.mPaint.getColor();
    }

    public float getWidth() {
        return this.mPaint.getStrokeWidth();
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    public boolean isGeodesic() {
        return this.mGeodesic;
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setWidth(float width) {
        this.mPaint.setStrokeWidth(width);
    }

    public void setVisible(boolean visible) {
        this.setEnabled(visible);
    }

    public void addGreatCircle(GeoPoint startPoint, GeoPoint endPoint, int numberOfPoints) {
        double lat1 = startPoint.getLatitude() * 0.01745329238474369;
        double lon1 = startPoint.getLongitude() * 0.01745329238474369;
        double lat2 = endPoint.getLatitude() * 0.01745329238474369;
        double lon2 = endPoint.getLongitude() * 0.01745329238474369;
        double d = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
        double bearing = Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)) / -0.01745329238474369;
        bearing = bearing < 0.0 ? 360.0 + bearing : bearing;
        int i = 1;
        while (i <= numberOfPoints) {
            double f = 1.0 * (double)i / (double)(numberOfPoints + 1);
            double A = Math.sin((1.0 - f) * d) / Math.sin(d);
            double B = Math.sin(f * d) / Math.sin(d);
            double x = A * Math.cos(lat1) * Math.cos(lon1) + B * Math.cos(lat2) * Math.cos(lon2);
            double y = A * Math.cos(lat1) * Math.sin(lon1) + B * Math.cos(lat2) * Math.sin(lon2);
            double z = A * Math.sin(lat1) + B * Math.sin(lat2);
            double latN = Math.atan2(z, Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)));
            double lonN = Math.atan2(y, x);
            this.addPoint((int)(latN * (double)57.29578f * 1000000.0), (int)(lonN * (double)57.29578f * 1000000.0));
            ++i;
        }
    }

    public void setPoints(List<GeoPoint> points) {
        this.clearPath();
        int size = points.size();
        this.mOriginalPoints = new int[size][2];
        int i = 0;
        while (i < size) {
            GeoPoint p = points.get(i);
            this.mOriginalPoints[i][0] = p.getLatitudeE6();
            this.mOriginalPoints[i][1] = p.getLongitudeE6();
            if (!this.mGeodesic) {
                super.addPoint((IGeoPoint)p);
            } else {
                if (i > 0) {
                    GeoPoint prev = points.get(i - 1);
                    int greatCircleLength = prev.distanceTo((IGeoPoint)p);
                    int numberOfPoints = greatCircleLength / 100000;
                    this.addGreatCircle(prev, p, numberOfPoints);
                }
                super.addPoint((IGeoPoint)p);
            }
            ++i;
        }
    }

    public void setGeodesic(boolean geodesic) {
        this.mGeodesic = geodesic;
    }
}

