/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.overlays;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.bonuspack.overlays.DefaultInfoWindow;
import org.osmdroid.bonuspack.overlays.ExtendedOverlayItem;
import org.osmdroid.bonuspack.overlays.InfoWindow;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public class Polygon
extends Overlay {
    private LinearRing mOutline;
    private ArrayList<LinearRing> mHoles;
    protected Paint mFillPaint;
    protected Paint mOutlinePaint;
    private final Path mPath = new Path();
    private final Point mTempPoint1 = new Point();
    private final Point mTempPoint2 = new Point();
    protected String mTitle;
    protected String mSnippet;
    protected InfoWindow mBubble;

    public Polygon(Context ctx) {
        this((ResourceProxy)new DefaultResourceProxyImpl(ctx));
    }

    public Polygon(ResourceProxy resourceProxy) {
        super(resourceProxy);
        this.mFillPaint = new Paint();
        this.mFillPaint.setColor(0);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mOutlinePaint = new Paint();
        this.mOutlinePaint.setColor(-16777216);
        this.mOutlinePaint.setStrokeWidth(10.0f);
        this.mOutlinePaint.setStyle(Paint.Style.STROKE);
        this.mOutline = new LinearRing();
        this.mHoles = new ArrayList();
        this.mTitle = "";
        this.mSnippet = "";
        this.mBubble = null;
        this.mPath.setFillType(Path.FillType.EVEN_ODD);
    }

    public int getFillColor() {
        return this.mFillPaint.getColor();
    }

    public int getStrokeColor() {
        return this.mOutlinePaint.getColor();
    }

    public float getStrokeWidth() {
        return this.mOutlinePaint.getStrokeWidth();
    }

    public List<GeoPoint> getPoints() {
        return this.mOutline.getPoints();
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    public void setFillColor(int fillColor) {
        this.mFillPaint.setColor(fillColor);
    }

    public void setStrokeColor(int color) {
        this.mOutlinePaint.setColor(color);
    }

    public void setStrokeWidth(float width) {
        this.mOutlinePaint.setStrokeWidth(width);
    }

    public void setVisible(boolean visible) {
        this.setEnabled(visible);
    }

    public void setPoints(List<GeoPoint> points) {
        this.mOutline.setPoints(points);
    }

    public void setHoles(List<? extends List<GeoPoint>> holes) {
        this.mHoles = new ArrayList(holes.size());
        for (List<GeoPoint> list : holes) {
            LinearRing newHole = new LinearRing();
            newHole.setPoints(list);
            this.mHoles.add(newHole);
        }
    }

    public List<ArrayList<GeoPoint>> getHoles() {
        ArrayList<ArrayList<GeoPoint>> result = new ArrayList<ArrayList<GeoPoint>>(this.mHoles.size());
        for (LinearRing hole : this.mHoles) {
            result.add(hole.getPoints());
        }
        return result;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setSnippet(String snippet) {
        this.mSnippet = snippet;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getSnippet() {
        return this.mSnippet;
    }

    public void setInfoWindow(int layoutResId, MapView mapView) {
        this.mBubble = layoutResId != 0 ? new DefaultInfoWindow(layoutResId, mapView) : null;
    }

    protected void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        MapView.Projection pj = mapView.getProjection();
        this.mPath.rewind();
        this.mOutline.buildPathPortion(pj);
        for (LinearRing hole : this.mHoles) {
            hole.buildPathPortion(pj);
        }
        canvas.drawPath(this.mPath, this.mFillPaint);
        canvas.drawPath(this.mPath, this.mOutlinePaint);
    }

    public boolean contains(MotionEvent event, MapView mapView) {
        if (this.mPath.isEmpty()) {
            return false;
        }
        MapView.Projection pj = mapView.getProjection();
        Point point = pj.fromMapPixels((int)event.getX(), (int)event.getY(), null);
        RectF bounds = new RectF();
        this.mPath.computeBounds(bounds, true);
        Region region = new Region();
        region.setPath(this.mPath, new Region((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom));
        return region.contains(point.x, point.y);
    }

    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        if (this.mBubble == null) {
            return false;
        }
        boolean touched = this.contains(event, mapView);
        if (touched) {
            MapView.Projection pj = mapView.getProjection();
            GeoPoint position = (GeoPoint)pj.fromPixels(event.getX(), event.getY());
            ExtendedOverlayItem item = new ExtendedOverlayItem(this.mTitle, this.mSnippet, position);
            this.mBubble.open((Object)item, item.getPoint(), 0, 0);
        }
        return touched;
    }

    class LinearRing {
        int[][] mOriginalPoints = new int[0][2];
        ArrayList<Point> mConvertedPoints = new ArrayList();
        boolean mPrecomputed = false;

        LinearRing() {
        }

        ArrayList<GeoPoint> getPoints() {
            int size = this.mOriginalPoints.length;
            ArrayList<GeoPoint> result = new ArrayList<GeoPoint>(size);
            int i = 0;
            while (i < size) {
                GeoPoint gp = new GeoPoint(this.mOriginalPoints[i][0], this.mOriginalPoints[i][1]);
                result.add(gp);
                ++i;
            }
            return result;
        }

        void setPoints(List<GeoPoint> points) {
            int size = points.size();
            this.mOriginalPoints = new int[size][2];
            this.mConvertedPoints = new ArrayList(size);
            int i = 0;
            for (GeoPoint p : points) {
                this.mOriginalPoints[i][0] = p.getLatitudeE6();
                this.mOriginalPoints[i][1] = p.getLongitudeE6();
                this.mConvertedPoints.add(new Point(p.getLatitudeE6(), p.getLongitudeE6()));
                ++i;
            }
            this.mPrecomputed = false;
        }

        protected void buildPathPortion(MapView.Projection pj) {
            int size = this.mConvertedPoints.size();
            if (size < 2) {
                return;
            }
            if (!this.mPrecomputed) {
                int i = 0;
                while (i < size) {
                    Point pt = this.mConvertedPoints.get(i);
                    pj.toMapPixelsProjected(pt.x, pt.y, pt);
                    ++i;
                }
                this.mPrecomputed = true;
            }
            Point projectedPoint0 = this.mConvertedPoints.get(0);
            Point screenPoint0 = pj.toMapPixelsTranslated(projectedPoint0, Polygon.this.mTempPoint1);
            Polygon.this.mPath.moveTo((float)screenPoint0.x, (float)screenPoint0.y);
            int i = 0;
            while (i < size) {
                Point projectedPoint1 = this.mConvertedPoints.get(i);
                Point screenPoint1 = pj.toMapPixelsTranslated(projectedPoint1, Polygon.this.mTempPoint2);
                if (Math.abs(screenPoint1.x - screenPoint0.x) + Math.abs(screenPoint1.y - screenPoint0.y) > 1) {
                    Polygon.this.mPath.lineTo((float)screenPoint1.x, (float)screenPoint1.y);
                    projectedPoint0 = projectedPoint1;
                    screenPoint0.x = screenPoint1.x;
                    screenPoint0.y = screenPoint1.y;
                }
                ++i;
            }
            Polygon.this.mPath.close();
        }
    }
}

