/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.overlays;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import org.osmdroid.bonuspack.overlays.InfoWindow;
import org.osmdroid.bonuspack.overlays.Marker;
import org.osmdroid.views.MapView;

public class MarkerInfoWindow
extends InfoWindow {
    static int mTitleId = 0;
    static int mDescriptionId = 0;
    static int mSubDescriptionId = 0;
    static int mImageId = 0;

    private static void setResIds(Context context) {
        String packageName = context.getPackageName();
        mTitleId = context.getResources().getIdentifier("id/bubble_title", null, packageName);
        mDescriptionId = context.getResources().getIdentifier("id/bubble_description", null, packageName);
        mSubDescriptionId = context.getResources().getIdentifier("id/bubble_subdescription", null, packageName);
        mImageId = context.getResources().getIdentifier("id/bubble_image", null, packageName);
        if (mTitleId == 0 || mDescriptionId == 0 || mSubDescriptionId == 0 || mImageId == 0) {
            Log.e((String)"BONUSPACK", (String)("MarkerInfoWindow: unable to get res ids in " + packageName));
        }
    }

    public MarkerInfoWindow(int layoutResId, MapView mapView) {
        super(layoutResId, mapView);
        if (mTitleId == 0) {
            MarkerInfoWindow.setResIds(mapView.getContext());
        }
        this.mView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent e) {
                if (e.getAction() == 1) {
                    MarkerInfoWindow.this.close();
                }
                return true;
            }
        });
    }

    @Override
    public void onOpen(Object item) {
        Marker marker = (Marker)((Object)item);
        String title = marker.getTitle();
        if (title == null) {
            title = "";
        }
        ((TextView)this.mView.findViewById(mTitleId)).setText((CharSequence)title);
        String snippet = marker.getSnippet();
        if (snippet == null) {
            snippet = "";
        }
        ((TextView)this.mView.findViewById(mDescriptionId)).setText((CharSequence)snippet);
        TextView subDescText = (TextView)this.mView.findViewById(mSubDescriptionId);
        String subDesc = marker.getSubDescription();
        if (subDesc != null && !"".equals(subDesc)) {
            subDescText.setText((CharSequence)subDesc);
            subDescText.setVisibility(0);
        } else {
            subDescText.setVisibility(8);
        }
        ImageView imageView = (ImageView)this.mView.findViewById(mImageId);
        Drawable image = marker.getImage();
        if (image != null) {
            imageView.setImageDrawable(image);
            imageView.setVisibility(0);
        } else {
            imageView.setVisibility(8);
        }
    }

    @Override
    public void onClose() {
    }
}

