/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.overlays;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.MotionEvent;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.bonuspack.overlays.InfoWindow;
import org.osmdroid.bonuspack.overlays.MarkerInfoWindow;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public class Marker
extends Overlay {
    protected Drawable mIcon;
    protected GeoPoint mPosition;
    protected float mBearing;
    protected float mAnchorU;
    protected float mAnchorV;
    protected float mIWAnchorU;
    protected float mIWAnchorV;
    protected float mAlpha;
    protected String mTitle;
    protected String mSnippet;
    protected boolean mDraggable;
    protected boolean mIsDragged;
    protected InfoWindow mInfoWindow;
    protected boolean mFlat;
    protected OnMarkerClickListener mOnMarkerClickListener;
    protected OnMarkerDragListener mOnMarkerDragListener;
    protected Drawable mImage;
    protected String mSubDescription;
    protected boolean mPanToView;
    protected Object mRelatedObject;
    protected Point mPositionPixels;
    protected ResourceProxy mResourceProxy;
    protected static MarkerInfoWindow mDefaultInfoWindow = null;
    public static final float ANCHOR_CENTER = 0.5f;
    public static final float ANCHOR_LEFT = 0.0f;
    public static final float ANCHOR_TOP = 0.0f;
    public static final float ANCHOR_RIGHT = 1.0f;
    public static final float ANCHOR_BOTTOM = 1.0f;

    public Marker(MapView mapView) {
        this(mapView, (ResourceProxy)new DefaultResourceProxyImpl(mapView.getContext()));
    }

    public Marker(MapView mapView, ResourceProxy resourceProxy) {
        super(resourceProxy);
        this.mResourceProxy = resourceProxy;
        this.mBearing = 0.0f;
        this.mAlpha = 1.0f;
        this.mPosition = new GeoPoint(0.0, 0.0);
        this.mAnchorU = 0.5f;
        this.mAnchorV = 0.5f;
        this.mIWAnchorU = 0.5f;
        this.mIWAnchorV = 0.0f;
        this.mDraggable = false;
        this.mIsDragged = false;
        this.mPositionPixels = new Point();
        this.mPanToView = true;
        this.mFlat = false;
        this.mOnMarkerClickListener = null;
        this.mOnMarkerDragListener = null;
        this.mIcon = resourceProxy.getDrawable(ResourceProxy.bitmap.marker_default);
        if (mDefaultInfoWindow == null) {
            Context context = mapView.getContext();
            String packageName = context.getPackageName();
            int defaultLayoutResId = context.getResources().getIdentifier("layout/bonuspack_bubble", null, packageName);
            if (defaultLayoutResId == 0) {
                Log.e((String)"BONUSPACK", (String)("Marker: layout/bonuspack_bubble not found in " + packageName));
            } else {
                mDefaultInfoWindow = new MarkerInfoWindow(defaultLayoutResId, mapView);
            }
        }
        this.mInfoWindow = mDefaultInfoWindow;
    }

    public void setIcon(Drawable icon) {
        this.mIcon = icon != null ? icon : this.mResourceProxy.getDrawable(ResourceProxy.bitmap.marker_default);
    }

    public GeoPoint getPosition() {
        return this.mPosition.clone();
    }

    public void setPosition(GeoPoint position) {
        this.mPosition = position.clone();
    }

    public float getRotation() {
        return this.mBearing;
    }

    public void setRotation(float rotation) {
        this.mBearing = rotation;
    }

    public void setAnchor(float anchorU, float anchorV) {
        this.mAnchorU = anchorU;
        this.mAnchorV = anchorV;
    }

    public void setInfoWindowAnchor(float anchorU, float anchorV) {
        this.mIWAnchorU = anchorU;
        this.mIWAnchorV = anchorV;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setSnippet(String snippet) {
        this.mSnippet = snippet;
    }

    public String getSnippet() {
        return this.mSnippet;
    }

    public void setDraggable(boolean draggable) {
        this.mDraggable = draggable;
    }

    public boolean isDraggable() {
        return this.mDraggable;
    }

    public void setFlat(boolean flat) {
        this.mFlat = flat;
    }

    public boolean isFlat() {
        return this.mFlat;
    }

    public void remove(MapView mapView) {
        mapView.getOverlays().remove((Object)this);
    }

    public void setOnMarkerClickListener(OnMarkerClickListener listener) {
        this.mOnMarkerClickListener = listener;
    }

    public void setOnMarkerDragListener(OnMarkerDragListener listener) {
        this.mOnMarkerDragListener = listener;
    }

    public void setSubDescription(String subDescription) {
        this.mSubDescription = subDescription;
    }

    public String getSubDescription() {
        return this.mSubDescription;
    }

    public void setImage(Drawable image) {
        this.mImage = image;
    }

    public Drawable getImage() {
        return this.mImage;
    }

    public void setInfoWindow(InfoWindow infoWindow) {
        this.mInfoWindow = infoWindow;
    }

    public void setPanToView(boolean panToView) {
        this.mPanToView = panToView;
    }

    public void setRelatedObject(Object relatedObject) {
        this.mRelatedObject = relatedObject;
    }

    public Object getRelatedObject() {
        return this.mRelatedObject;
    }

    public void showInfoWindow() {
        if (this.mInfoWindow == null) {
            return;
        }
        int markerWidth = 0;
        int markerHeight = 0;
        markerWidth = this.mIcon.getIntrinsicWidth();
        markerHeight = this.mIcon.getIntrinsicHeight();
        int offsetX = (int)(this.mIWAnchorU * (float)markerWidth) - (int)(this.mAnchorU * (float)markerWidth);
        int offsetY = (int)(this.mIWAnchorV * (float)markerHeight) - (int)(this.mAnchorV * (float)markerHeight);
        this.mInfoWindow.open((Object)this, this.mPosition, offsetX, offsetY);
    }

    public void hideInfoWindow() {
        if (this.mInfoWindow != null) {
            this.mInfoWindow.close();
        }
    }

    public boolean isInfoWindowShown() {
        return this.mInfoWindow != null && this.mInfoWindow.isOpen();
    }

    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mIcon == null) {
            return;
        }
        MapView.Projection pj = mapView.getProjection();
        pj.toMapPixels((IGeoPoint)this.mPosition, this.mPositionPixels);
        int width = this.mIcon.getIntrinsicWidth();
        int height = this.mIcon.getIntrinsicHeight();
        Rect rect = new Rect(0, 0, width, height);
        rect.offset(-((int)(this.mAnchorU * (float)width)), -((int)(this.mAnchorV * (float)height)));
        this.mIcon.setBounds(rect);
        this.mIcon.setAlpha((int)(this.mAlpha * 255.0f));
        float rotationOnScreen = this.mFlat ? -this.mBearing : mapView.getMapOrientation() - this.mBearing;
        Marker.drawAt((Canvas)canvas, (Drawable)this.mIcon, (int)this.mPositionPixels.x, (int)this.mPositionPixels.y, (boolean)false, (float)rotationOnScreen);
    }

    public boolean hitTest(MotionEvent event, MapView mapView) {
        MapView.Projection pj = mapView.getProjection();
        pj.toMapPixels((IGeoPoint)this.mPosition, this.mPositionPixels);
        Rect screenRect = pj.getIntrinsicScreenRect();
        int x = -this.mPositionPixels.x + screenRect.left + (int)event.getX();
        int y = -this.mPositionPixels.y + screenRect.top + (int)event.getY();
        boolean hit = this.mIcon.getBounds().contains(x, y);
        return hit;
    }

    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        boolean touched = this.hitTest(event, mapView);
        if (touched) {
            if (this.mOnMarkerClickListener == null) {
                return this.onMarkerClickDefault(this, mapView);
            }
            return this.mOnMarkerClickListener.onMarkerClick(this, mapView);
        }
        return touched;
    }

    public void moveToEventPosition(MotionEvent event, MapView mapView) {
        MapView.Projection pj = mapView.getProjection();
        this.mPosition = (GeoPoint)pj.fromPixels(event.getX(), event.getY());
        mapView.invalidate();
    }

    public boolean onLongPress(MotionEvent event, MapView mapView) {
        boolean touched = this.hitTest(event, mapView);
        if (touched && this.mDraggable) {
            this.mIsDragged = true;
            this.hideInfoWindow();
            if (this.mOnMarkerDragListener != null) {
                this.mOnMarkerDragListener.onMarkerDragStart(this);
            }
            this.moveToEventPosition(event, mapView);
        }
        return touched;
    }

    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        if (this.mDraggable && this.mIsDragged) {
            if (event.getAction() == 1) {
                this.mIsDragged = false;
                if (this.mOnMarkerDragListener != null) {
                    this.mOnMarkerDragListener.onMarkerDragEnd(this);
                }
                return true;
            }
            if (event.getAction() == 2) {
                this.moveToEventPosition(event, mapView);
                if (this.mOnMarkerDragListener != null) {
                    this.mOnMarkerDragListener.onMarkerDrag(this);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean onMarkerClickDefault(Marker marker, MapView mapView) {
        marker.showInfoWindow();
        if (marker.mPanToView) {
            mapView.getController().animateTo((IGeoPoint)marker.getPosition());
        }
        return true;
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1, MapView var2);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }
}

