/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.overlays;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import org.osmdroid.DefaultResourceProxyImpl;
import org.osmdroid.ResourceProxy;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.SafeDrawOverlay;
import org.osmdroid.views.safecanvas.ISafeCanvas;

public class GroundOverlay
extends SafeDrawOverlay {
    protected Drawable mImage;
    protected GeoPoint mPosition;
    protected float mBearing = 0.0f;
    protected float mWidth = 10.0f;
    protected float mHeight = -1.0f;
    protected float mTransparency = 0.0f;
    public static final float NO_DIMENSION = -1.0f;
    protected Point mPositionPixels = new Point();
    protected Point mSouthEastPixels = new Point();

    public GroundOverlay(Context ctx) {
        this((ResourceProxy)new DefaultResourceProxyImpl(ctx));
    }

    public GroundOverlay(ResourceProxy resourceProxy) {
        super(resourceProxy);
    }

    public void setImage(Drawable image) {
        this.mImage = image;
    }

    public Drawable getImage() {
        return this.mImage;
    }

    public GeoPoint getPosition() {
        return this.mPosition.clone();
    }

    public void setPosition(GeoPoint position) {
        this.mPosition = position.clone();
    }

    public float getBearing() {
        return this.mBearing;
    }

    public void setBearing(float bearing) {
        this.mBearing = bearing;
    }

    public void setDimensions(float width) {
        this.mWidth = width;
        this.mHeight = -1.0f;
    }

    public void setDimensions(float width, float height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public void setTransparency(float transparency) {
        this.mTransparency = transparency;
    }

    public float getTransparency() {
        return this.mTransparency;
    }

    protected void drawSafe(ISafeCanvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.mImage == null) {
            return;
        }
        if (this.mHeight == -1.0f) {
            this.mHeight = this.mWidth * (float)this.mImage.getIntrinsicHeight() / (float)this.mImage.getIntrinsicWidth();
        }
        MapView.Projection pj = mapView.getProjection();
        pj.toMapPixels((IGeoPoint)this.mPosition, this.mPositionPixels);
        GeoPoint pEast = this.mPosition.destinationPoint((double)this.mWidth, 90.0f);
        GeoPoint pSouthEast = pEast.destinationPoint((double)this.mHeight, -180.0f);
        pj.toMapPixels((IGeoPoint)pSouthEast, this.mSouthEastPixels);
        int width = this.mSouthEastPixels.x - this.mPositionPixels.x;
        int height = this.mSouthEastPixels.y - this.mPositionPixels.y;
        this.mImage.setBounds(-width / 2, -height / 2, width / 2, height / 2);
        this.mImage.setAlpha(255 - (int)(this.mTransparency * 255.0f));
        GroundOverlay.drawAt((Canvas)canvas.getSafeCanvas(), (Drawable)this.mImage, (int)this.mPositionPixels.x, (int)this.mPositionPixels.y, (boolean)false, (float)(-this.mBearing));
    }
}

