/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import java.util.ArrayList;
import org.osmdroid.bonuspack.location.POI;
import org.osmdroid.util.GeoPoint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class PicasaXMLHandler
extends DefaultHandler {
    private String mString;
    double mLat;
    double mLng;
    POI mPOI;
    ArrayList<POI> mPOIs = new ArrayList();
    int mTotalResults;
    static final int MAX_DESC_SIZE = 250;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String rel;
        if (qName.equals("entry")) {
            this.mPOI = new POI(POI.POI_SERVICE_PICASA);
        } else if (qName.equals("media:thumbnail")) {
            this.mPOI.mThumbnailPath = attributes.getValue("url");
        } else if (qName.equals("link") && "http://schemas.google.com/photos/2007#canonical".equals(rel = attributes.getValue("rel"))) {
            this.mPOI.mUrl = attributes.getValue("href");
            this.mPOI.mUrl = this.mPOI.mUrl.replaceFirst("https://", "http://");
        }
        this.mString = new String();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        this.mString = this.mString.concat(chars);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("gml:pos")) {
            String[] coords = this.mString.split(" ");
            this.mLat = Double.parseDouble(coords[0]);
            this.mLng = Double.parseDouble(coords[1]);
        } else if (qName.equals("gphoto:id")) {
            this.mPOI.mId = Long.parseLong(this.mString);
        } else if (qName.equals("media:title")) {
            this.mPOI.mType = this.mString;
        } else if (qName.equals("summary")) {
            this.mPOI.mDescription = this.mString;
            if (this.mPOI.mDescription.length() > 250) {
                this.mPOI.mDescription = String.valueOf(this.mPOI.mDescription.substring(0, 250)) + " (...)";
            }
        } else if (qName.equals("gphoto:albumtitle")) {
            this.mPOI.mCategory = this.mString;
        } else if (qName.equals("entry")) {
            this.mPOI.mLocation = new GeoPoint(this.mLat, this.mLng);
            this.mPOIs.add(this.mPOI);
            this.mPOI = null;
        } else if (qName.equals("openSearch:totalResults")) {
            this.mTotalResults = Integer.parseInt(this.mString);
        }
    }
}

