/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osmdroid.bonuspack.location.POI;
import org.osmdroid.bonuspack.location.PicasaXMLHandler;
import org.osmdroid.bonuspack.utils.HttpConnection;
import org.osmdroid.util.BoundingBoxE6;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PicasaPOIProvider {
    String mAccessToken;

    public PicasaPOIProvider(String accessToken) {
        this.mAccessToken = accessToken;
    }

    private String getUrlInside(BoundingBoxE6 boundingBox, int maxResults, String query) {
        StringBuffer url = new StringBuffer("http://picasaweb.google.com/data/feed/api/all?");
        url.append("bbox=" + (double)boundingBox.getLonWestE6() * 1.0E-6);
        url.append("," + (double)boundingBox.getLatSouthE6() * 1.0E-6);
        url.append("," + (double)boundingBox.getLonEastE6() * 1.0E-6);
        url.append("," + (double)boundingBox.getLatNorthE6() * 1.0E-6);
        url.append("&max-results=" + maxResults);
        url.append("&thumbsize=64c");
        url.append("&fields=openSearch:totalResults,entry(summary,media:group/media:thumbnail,media:group/media:title,gphoto:*,georss:where,link)");
        if (query != null) {
            url.append("&q=" + URLEncoder.encode(query));
        }
        if (this.mAccessToken != null) {
            url.append("&access_token=" + this.mAccessToken);
        }
        return url.toString();
    }

    public ArrayList<POI> getThem(String fullUrl) {
        Log.d((String)"BONUSPACK", (String)("PicasaPOIProvider:get:" + fullUrl));
        HttpConnection connection = new HttpConnection();
        connection.doGet(fullUrl);
        InputStream stream = connection.getStream();
        if (stream == null) {
            return null;
        }
        PicasaXMLHandler handler = new PicasaXMLHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", false);
            parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.parse(stream, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        connection.close();
        if (handler.mPOIs != null) {
            Log.d((String)"BONUSPACK", (String)("done:" + handler.mPOIs.size() + " got, on a total of:" + handler.mTotalResults));
        }
        return handler.mPOIs;
    }

    public ArrayList<POI> getPOIInside(BoundingBoxE6 boundingBox, int maxResults, String query) {
        String url = this.getUrlInside(boundingBox, maxResults, query);
        return this.getThem(url);
    }
}

