/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.util.GeoPoint;

public class KmlPolygon
extends KmlGeometry {
    public ArrayList<ArrayList<GeoPoint>> mHoles;
    public static final Parcelable.Creator<KmlPolygon> CREATOR = new Parcelable.Creator<KmlPolygon>(){

        public KmlPolygon createFromParcel(Parcel source) {
            return new KmlPolygon(source);
        }

        public KmlPolygon[] newArray(int size) {
            return new KmlPolygon[size];
        }
    };

    public KmlPolygon() {
        this.mType = 3;
    }

    public KmlPolygon(JSONObject json) {
        this();
        JSONArray rings = json.optJSONArray("coordinates");
        this.mCoordinates = KmlGeometry.parseGeoJSONPositions(rings.optJSONArray(0));
        if (rings.length() > 1) {
            this.mHoles = new ArrayList(rings.length() - 1);
            int i = 1;
            while (i < rings.length()) {
                ArrayList<GeoPoint> hole = KmlGeometry.parseGeoJSONPositions(rings.optJSONArray(i));
                this.mHoles.add(hole);
                ++i;
            }
        }
    }

    @Override
    public void saveAsKML(Writer writer) {
        try {
            writer.write("<Polygon>\n");
            writer.write("<outerBoundaryIs>\n<LinearRing>\n");
            this.writeKMLCoordinates(writer, this.mCoordinates);
            writer.write("</LinearRing>\n</outerBoundaryIs>\n");
            if (this.mHoles != null) {
                for (ArrayList<GeoPoint> hole : this.mHoles) {
                    writer.write("<innerBoundaryIs>\n<LinearRing>\n");
                    this.writeKMLCoordinates(writer, hole);
                    writer.write("</LinearRing>\n</innerBoundaryIs>\n");
                }
            }
            writer.write("</Polygon>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject asGeoJSON() {
        try {
            JSONObject json = new JSONObject();
            json.put("type", (Object)"Polygon");
            JSONArray coords = new JSONArray();
            coords.put((Object)KmlGeometry.geoJSONCoordinates(this.mCoordinates));
            if (this.mHoles != null) {
                for (ArrayList<GeoPoint> hole : this.mHoles) {
                    coords.put((Object)KmlGeometry.geoJSONCoordinates(hole));
                }
            }
            json.put("coordinates", (Object)coords);
            return json;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public KmlPolygon clone() {
        KmlPolygon kmlPolygon = (KmlPolygon)super.clone();
        if (this.mHoles != null) {
            kmlPolygon.mHoles = new ArrayList(this.mHoles.size());
            for (ArrayList<GeoPoint> hole : this.mHoles) {
                kmlPolygon.mHoles.add(KmlPolygon.cloneArrayOfGeoPoint(hole));
            }
        }
        return kmlPolygon;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        if (this.mHoles != null) {
            out.writeInt(this.mHoles.size());
            for (ArrayList<GeoPoint> l : this.mHoles) {
                out.writeList(l);
            }
        } else {
            out.writeInt(0);
        }
    }

    public KmlPolygon(Parcel in) {
        super(in);
        int holes = in.readInt();
        if (holes != 0) {
            this.mHoles = new ArrayList(holes);
            int i = 0;
            while (i < holes) {
                ArrayList l = in.readArrayList(GeoPoint.class.getClassLoader());
                this.mHoles.add(l);
                ++i;
            }
        }
    }
}

