/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.util.GeoPoint;

public class KmlPoint
extends KmlGeometry
implements Parcelable,
Cloneable {
    public static final Parcelable.Creator<KmlPoint> CREATOR = new Parcelable.Creator<KmlPoint>(){

        public KmlPoint createFromParcel(Parcel source) {
            return new KmlPoint(source);
        }

        public KmlPoint[] newArray(int size) {
            return new KmlPoint[size];
        }
    };

    public KmlPoint() {
        this.mType = 1;
    }

    public KmlPoint(GeoPoint position) {
        this();
        this.mCoordinates = new ArrayList(1);
        this.mCoordinates.add(position);
    }

    public KmlPoint(JSONObject json) {
        this();
        this.mCoordinates = new ArrayList(1);
        JSONArray coordinates = json.optJSONArray("coordinates");
        if (coordinates != null) {
            this.mCoordinates.add(KmlGeometry.parseGeoJSONPosition(coordinates));
        }
    }

    public void setPosition(GeoPoint position) {
        this.mCoordinates.set(0, position);
    }

    public GeoPoint getPosition() {
        return (GeoPoint)this.mCoordinates.get(0);
    }

    @Override
    public void saveAsKML(Writer writer) {
        try {
            writer.write("<Point>\n");
            this.writeKMLCoordinates(writer, this.mCoordinates);
            writer.write("</Point>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject asGeoJSON() {
        try {
            JSONObject json = new JSONObject();
            json.put("type", (Object)"Point");
            json.put("coordinates", (Object)KmlGeometry.geoJSONPosition((GeoPoint)this.mCoordinates.get(0)));
            return json;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public KmlPoint clone() {
        KmlPoint kmlPoint = (KmlPoint)super.clone();
        return kmlPoint;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
    }

    public KmlPoint(Parcel in) {
        super(in);
    }
}

