/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.kml.ColorStyle;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlLineString;
import org.osmdroid.bonuspack.kml.KmlPoint;
import org.osmdroid.bonuspack.kml.KmlPolygon;
import org.osmdroid.bonuspack.kml.LineStyle;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.bonuspack.overlays.Marker;
import org.osmdroid.bonuspack.overlays.Polygon;
import org.osmdroid.bonuspack.overlays.Polyline;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public class KmlPlacemark
extends KmlFeature
implements Cloneable,
Parcelable {
    public KmlGeometry mGeometry;
    public static final Parcelable.Creator<KmlPlacemark> CREATOR = new Parcelable.Creator<KmlPlacemark>(){

        public KmlPlacemark createFromParcel(Parcel source) {
            return new KmlPlacemark(source);
        }

        public KmlPlacemark[] newArray(int size) {
            return new KmlPlacemark[size];
        }
    };

    public KmlPlacemark() {
        this.mObjectType = 1;
    }

    public KmlPlacemark(GeoPoint position) {
        this();
        this.mGeometry = new KmlPoint(position);
        this.mBB = new BoundingBoxE6(position.getLatitudeE6(), position.getLongitudeE6(), position.getLatitudeE6(), position.getLongitudeE6());
    }

    public KmlPlacemark(Marker marker) {
        this(marker.getPosition());
        this.mName = marker.getTitle();
        this.mDescription = marker.getSnippet();
        this.mVisibility = marker.isEnabled();
    }

    public KmlPlacemark(Polygon polygon, KmlDocument kmlDoc) {
        this();
        this.mName = polygon.getTitle();
        this.mDescription = polygon.getSnippet();
        this.mGeometry = new KmlPolygon();
        this.mGeometry.mCoordinates = (ArrayList)polygon.getPoints();
        ((KmlPolygon)this.mGeometry).mHoles = (ArrayList)polygon.getHoles();
        this.mBB = BoundingBoxE6.fromGeoPoints(this.mGeometry.mCoordinates);
        this.mVisibility = polygon.isEnabled();
        Style style = new Style();
        style.mPolyStyle = new ColorStyle(polygon.getFillColor());
        style.mLineStyle = new LineStyle(polygon.getStrokeColor(), polygon.getStrokeWidth());
        this.mStyle = kmlDoc.addStyle(style);
    }

    public KmlPlacemark(Polyline polyline, KmlDocument kmlDoc) {
        this();
        this.mName = "LineString - " + polyline.getNumberOfPoints() + " points";
        this.mGeometry = new KmlLineString();
        this.mGeometry.mCoordinates = (ArrayList)polyline.getPoints();
        this.mBB = BoundingBoxE6.fromGeoPoints(this.mGeometry.mCoordinates);
        this.mVisibility = polyline.isEnabled();
        Style style = new Style();
        style.mLineStyle = new LineStyle(polyline.getColor(), polyline.getWidth());
        this.mStyle = kmlDoc.addStyle(style);
    }

    public KmlPlacemark(JSONObject json) {
        this();
        this.mId = json.optString("id");
        JSONObject geometry = json.optJSONObject("geometry");
        if (geometry != null) {
            this.mGeometry = KmlGeometry.parseGeoJSON(geometry);
        }
        JSONObject properties = json.optJSONObject("properties");
        Iterator keys = properties.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = properties.optString(key);
            if (key == null || value == null) continue;
            this.setExtendedData(key, value);
        }
        if (this.mExtendedData != null && this.mExtendedData.containsKey("name")) {
            this.mName = (String)this.mExtendedData.get("name");
            this.mExtendedData.remove("name");
        }
    }

    public Overlay buildMarkerFromPoint(MapView map, Drawable defaultIcon, KmlDocument kmlDocument, boolean supportVisibility) {
        Context context = map.getContext();
        Marker marker = new Marker(map);
        marker.setTitle(this.mName);
        marker.setSnippet(this.mDescription);
        marker.setPosition(((KmlPoint)this.mGeometry).getPosition());
        Style style = kmlDocument.getStyle(this.mStyle);
        if (style != null && style.mIconStyle != null) {
            style.mIconStyle.styleMarker(marker, context);
        } else {
            if (defaultIcon != null) {
                marker.setIcon(defaultIcon);
            }
            marker.setAnchor(0.5f, 1.0f);
        }
        marker.setRelatedObject(this);
        marker.setDraggable(true);
        marker.setOnMarkerDragListener(new OnKMLMarkerDragListener());
        if (supportVisibility && !this.mVisibility) {
            marker.setEnabled(this.mVisibility);
        }
        return marker;
    }

    public Overlay buildPolylineFromLineString(MapView map, KmlDocument kmlDocument, boolean supportVisibility) {
        Context context = map.getContext();
        Polyline lineStringOverlay = new Polyline(context);
        Style style = kmlDocument.getStyle(this.mStyle);
        if (style != null) {
            lineStringOverlay.setPaint(style.getOutlinePaint());
        } else {
            lineStringOverlay.setColor(-1877995504);
            lineStringOverlay.setWidth(5.0f);
        }
        lineStringOverlay.setPoints(this.mGeometry.mCoordinates);
        if (supportVisibility && !this.mVisibility) {
            lineStringOverlay.setEnabled(this.mVisibility);
        }
        return lineStringOverlay;
    }

    public Overlay buildPolygonFromPolygon(MapView map, KmlDocument kmlDocument, boolean supportVisibility) {
        Context context = map.getContext();
        Polygon polygonOverlay = new Polygon(context);
        Style style = kmlDocument.getStyle(this.mStyle);
        Paint outlinePaint = null;
        int fillColor = 0x20101010;
        if (style != null) {
            outlinePaint = style.getOutlinePaint();
            fillColor = style.mPolyStyle.getFinalColor();
        }
        if (outlinePaint == null) {
            outlinePaint = new Paint();
            outlinePaint.setColor(-1877995504);
            outlinePaint.setStrokeWidth(5.0f);
        }
        polygonOverlay.setFillColor(fillColor);
        polygonOverlay.setStrokeColor(outlinePaint.getColor());
        polygonOverlay.setStrokeWidth(outlinePaint.getStrokeWidth());
        polygonOverlay.setPoints(this.mGeometry.mCoordinates);
        if (((KmlPolygon)this.mGeometry).mHoles != null) {
            polygonOverlay.setHoles(((KmlPolygon)this.mGeometry).mHoles);
        }
        polygonOverlay.setTitle(this.mName);
        polygonOverlay.setSnippet(this.mDescription);
        if (this.mName != null && !"".equals(this.mName) || this.mDescription != null && !"".equals(this.mDescription)) {
            String packageName = context.getPackageName();
            int layoutResId = context.getResources().getIdentifier("layout/bonuspack_bubble", null, packageName);
            polygonOverlay.setInfoWindow(layoutResId, map);
        }
        if (supportVisibility && !this.mVisibility) {
            polygonOverlay.setEnabled(this.mVisibility);
        }
        return polygonOverlay;
    }

    @Override
    public Overlay buildOverlay(MapView map, Drawable defaultIcon, KmlDocument kmlDocument, boolean supportVisibility) {
        switch (this.mGeometry.mType) {
            case 1: {
                return this.buildMarkerFromPoint(map, defaultIcon, kmlDocument, supportVisibility);
            }
            case 2: {
                return this.buildPolylineFromLineString(map, kmlDocument, supportVisibility);
            }
            case 3: {
                return this.buildPolygonFromPolygon(map, kmlDocument, supportVisibility);
            }
        }
        return null;
    }

    @Override
    public void writeKMLSpecifics(Writer writer) {
        if (this.mGeometry != null) {
            this.mGeometry.saveAsKML(writer);
        }
    }

    protected JSONObject geoJSONProperties() {
        try {
            JSONObject json = new JSONObject();
            if (this.mName != null) {
                json.put("name", (Object)this.mName);
            }
            if (this.mExtendedData != null) {
                for (Map.Entry entry : this.mExtendedData.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    json.put(name, (Object)value);
                }
            }
            return json;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JSONObject asGeoJSON(boolean isRoot) {
        JSONObject json = new JSONObject();
        try {
            json.put("type", (Object)"Feature");
            if (this.mId != null) {
                json.put("id", (Object)this.mId);
            }
            json.put("geometry", (Object)this.mGeometry.asGeoJSON());
            json.put("properties", (Object)this.geoJSONProperties());
            return json;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public KmlPlacemark clone() {
        KmlPlacemark kmlPlacemark = (KmlPlacemark)super.clone();
        if (this.mGeometry != null) {
            kmlPlacemark.mGeometry = this.mGeometry.clone();
        }
        return kmlPlacemark;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeParcelable((Parcelable)this.mGeometry, flags);
    }

    public KmlPlacemark(Parcel in) {
        super(in);
        in.readParcelable(KmlGeometry.class.getClassLoader());
    }

    public class OnKMLMarkerDragListener
    implements Marker.OnMarkerDragListener {
        @Override
        public void onMarkerDrag(Marker marker) {
        }

        @Override
        public void onMarkerDragEnd(Marker marker) {
            KmlPlacemark placemark;
            KmlFeature feature = (KmlFeature)marker.getRelatedObject();
            if (feature != null && feature.isA(1) && (placemark = (KmlPlacemark)feature).isA(1)) {
                KmlPoint point = (KmlPoint)placemark.mGeometry;
                point.setPosition(marker.getPosition());
            }
        }

        @Override
        public void onMarkerDragStart(Marker marker) {
        }
    }
}

