/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.Writer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.kml.KmlGeometry;

public class KmlLineString
extends KmlGeometry {
    public static final Parcelable.Creator<KmlLineString> CREATOR = new Parcelable.Creator<KmlLineString>(){

        public KmlLineString createFromParcel(Parcel source) {
            return new KmlLineString(source);
        }

        public KmlLineString[] newArray(int size) {
            return new KmlLineString[size];
        }
    };

    public KmlLineString() {
        this.mType = 2;
    }

    public KmlLineString(JSONObject json) {
        this();
        JSONArray coordinates = json.optJSONArray("coordinates");
        this.mCoordinates = KmlGeometry.parseGeoJSONPositions(coordinates);
    }

    @Override
    public void saveAsKML(Writer writer) {
        try {
            writer.write("<LineString>\n");
            this.writeKMLCoordinates(writer, this.mCoordinates);
            writer.write("</LineString>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject asGeoJSON() {
        try {
            JSONObject json = new JSONObject();
            json.put("type", (Object)"LineString");
            json.put("coordinates", (Object)KmlGeometry.geoJSONCoordinates(this.mCoordinates));
            return json;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public KmlLineString clone() {
        KmlLineString kmlLineString = (KmlLineString)super.clone();
        return kmlLineString;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
    }

    public KmlLineString(Parcel in) {
        super(in);
    }
}

