/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.json.JSONObject;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.bonuspack.kml.ColorStyle;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.overlays.GroundOverlay;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public class KmlGroundOverlay
extends KmlFeature
implements Cloneable,
Parcelable {
    public String mIconHref;
    public Bitmap mIcon;
    public int mColor;
    public float mRotation;
    public ArrayList<GeoPoint> mCoordinates;
    public static final Parcelable.Creator<KmlGroundOverlay> CREATOR = new Parcelable.Creator<KmlGroundOverlay>(){

        public KmlGroundOverlay createFromParcel(Parcel source) {
            return new KmlGroundOverlay(source);
        }

        public KmlGroundOverlay[] newArray(int size) {
            return new KmlGroundOverlay[size];
        }
    };

    public KmlGroundOverlay() {
        this.mObjectType = 4;
        this.mColor = -16777216;
    }

    public KmlGroundOverlay(GroundOverlay overlay) {
        this();
        GeoPoint p = overlay.getPosition();
        GeoPoint pN = p.destinationPoint((double)(overlay.getHeight() / 2.0f), 0.0f);
        GeoPoint pS = p.destinationPoint((double)(overlay.getHeight() / 2.0f), 180.0f);
        GeoPoint pE = p.destinationPoint((double)(overlay.getWidth() / 2.0f), 90.0f);
        GeoPoint pW = p.destinationPoint((double)(overlay.getWidth() / 2.0f), -90.0f);
        this.mCoordinates = new ArrayList(2);
        this.mCoordinates.add(new GeoPoint(pN.getLatitudeE6(), pW.getLongitudeE6()));
        this.mCoordinates.add(new GeoPoint(pS.getLatitudeE6(), pE.getLongitudeE6()));
        this.mBB = BoundingBoxE6.fromGeoPoints(this.mCoordinates);
        this.mIcon = ((BitmapDrawable)overlay.getImage()).getBitmap();
        this.mRotation = -overlay.getBearing();
        this.mColor = 255 - Color.alpha((int)((int)(overlay.getTransparency() * 255.0f)));
        this.mVisibility = overlay.isEnabled();
    }

    public void setIcon(String href, String containerFullPath) {
        this.mIconHref = href;
        if (this.mIconHref.startsWith("http://") || this.mIconHref.startsWith("https://")) {
            this.mIcon = BonusPackHelper.loadBitmap(this.mIconHref);
        } else {
            File file = new File(containerFullPath);
            String actualFullPath = String.valueOf(file.getParent()) + '/' + this.mIconHref;
            this.mIcon = BitmapFactory.decodeFile((String)actualFullPath);
        }
    }

    public void setLatLonBox(double north, double south, double east, double west) {
        this.mCoordinates = new ArrayList(2);
        this.mCoordinates.add(new GeoPoint(north, west));
        this.mCoordinates.add(new GeoPoint(south, east));
        this.mBB = BoundingBoxE6.fromGeoPoints(this.mCoordinates);
    }

    @Override
    public Overlay buildOverlay(MapView map, Drawable defaultIcon, KmlDocument kmlDocument, boolean supportVisibility) {
        Context context = map.getContext();
        GroundOverlay overlay = new GroundOverlay(context);
        if (this.mCoordinates.size() == 2) {
            GeoPoint pNW = this.mCoordinates.get(0);
            GeoPoint pSE = this.mCoordinates.get(1);
            overlay.setPosition(GeoPoint.fromCenterBetween((GeoPoint)pNW, (GeoPoint)pSE));
            GeoPoint pNE = new GeoPoint(pNW.getLatitude(), pSE.getLongitude());
            int width = pNE.distanceTo((IGeoPoint)pNW);
            GeoPoint pSW = new GeoPoint(pSE.getLatitude(), pNW.getLongitude());
            int height = pSW.distanceTo((IGeoPoint)pNW);
            overlay.setDimensions(width, height);
        }
        if (this.mIcon != null) {
            overlay.setImage((Drawable)new BitmapDrawable(this.mIcon));
        }
        float transparency = 1.0f - (float)Color.alpha((int)this.mColor) / 255.0f;
        overlay.setTransparency(transparency);
        overlay.setBearing(-this.mRotation);
        if (supportVisibility) {
            overlay.setEnabled(this.mVisibility);
        }
        return overlay;
    }

    @Override
    public void writeKMLSpecifics(Writer writer) {
        try {
            writer.write("<color>" + ColorStyle.colorAsKMLString(this.mColor) + "</color>\n");
            writer.write("<Icon><href>" + this.mIconHref + "</href></Icon>\n");
            writer.write("<LatLonBox>");
            GeoPoint pNW = this.mCoordinates.get(0);
            GeoPoint pSE = this.mCoordinates.get(1);
            writer.write("<north>" + pNW.getLatitude() + "</north>");
            writer.write("<south>" + pSE.getLatitude() + "</south>");
            writer.write("<east>" + pSE.getLongitude() + "</east>");
            writer.write("<west>" + pNW.getLongitude() + "</west>");
            writer.write("<rotation>" + this.mRotation + "</rotation>");
            writer.write("</LatLonBox>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject asGeoJSON(boolean isRoot) {
        return null;
    }

    @Override
    public KmlGroundOverlay clone() {
        KmlGroundOverlay kmlGroundOverlay = (KmlGroundOverlay)super.clone();
        kmlGroundOverlay.mCoordinates = KmlGeometry.cloneArrayOfGeoPoint(this.mCoordinates);
        return kmlGroundOverlay;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeString(this.mIconHref);
        out.writeParcelable((Parcelable)this.mIcon, flags);
        out.writeInt(this.mColor);
        out.writeFloat(this.mRotation);
        out.writeList(this.mCoordinates);
    }

    public KmlGroundOverlay(Parcel in) {
        super(in);
        this.mIconHref = in.readString();
        this.mIcon = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
        this.mColor = in.readInt();
        this.mRotation = in.readFloat();
        this.mCoordinates = in.readArrayList(GeoPoint.class.getClassLoader());
    }
}

